/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public final class EnvFont {
    private static volatile boolean isInitialized = false;
    private static Map<String, Font> fMap;
    private static FontRenderContext frCtx;
    private static Font defaultFont;

    public static Font getFont(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        EnvFont.initialize();
        name = name.toLowerCase();
        return fMap.get(name);
    }

    private static synchronized void initialize() {
        if (!isInitialized) {
            Font[] allFonts;
            defaultFont = null;
            fMap = new HashMap<String, Font>();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (Font font : allFonts = ge.getAllFonts()) {
                fMap.put(font.getFontName().toLowerCase(), font);
                fMap.put(font.getFamily().toLowerCase(), font);
            }
            if (fMap.get("\u5b8b\u4f53") != null) {
                defaultFont = fMap.get("\u5b8b\u4f53");
            } else if (fMap.get("simsun") != null) {
                defaultFont = fMap.get("simsun");
            } else if (fMap.get("microsoftyahei") != null) {
                defaultFont = fMap.get("microsoftyahei");
            } else if (fMap.get("stheiti-light") != null) {
                defaultFont = fMap.get("stheiti-light");
            } else if (fMap.get("times new roman") != null) {
                defaultFont = fMap.get("times new roman");
            } else if (fMap.get("serif") != null) {
                defaultFont = fMap.get("serif");
            } else if (!fMap.isEmpty()) {
                defaultFont = fMap.values().iterator().next();
            }
            isInitialized = true;
        }
    }

    public static Font getFont(String name, String family) {
        Font res = null;
        if (name != null) {
            res = EnvFont.getFont(name);
        }
        if (res != null) {
            return res;
        }
        if (family != null) {
            res = EnvFont.getFont(family);
        }
        return res;
    }

    public static synchronized void setMapping(String name, Font font) {
        if (name == null || name.equals("")) {
            return;
        }
        fMap.put(name, font);
    }

    public static void load(Path dirPath) throws IOException {
        if (dirPath == null || !Files.isDirectory(dirPath, new LinkOption[0])) {
            return;
        }
        EnvFont.initialize();
        try (Stream<Path> walk = Files.walk(dirPath, new FileVisitOption[0]);){
            walk.filter(p -> {
                String fileName = p.getFileName().toString().toLowerCase();
                return fileName.endsWith(".otf") || fileName.endsWith(".ttf");
            }).forEach(p -> {
                try {
                    Font font = Font.createFont(0, p.toFile());
                    fMap.put(font.getFontName().toLowerCase(), font);
                    fMap.put(font.getFamily().toLowerCase(), font);
                }
                catch (Exception e) {
                    System.err.println("\u52a0\u8f7d\u5b57\u4f53\u6587\u4ef6\u5931\u8d25\uff1a" + p + "\uff0c\u9519\u8bef\uff1a" + e.getMessage());
                }
            });
        }
    }

    public static Rectangle2D strBounds(String name, String family, String str, double size) {
        Font font = EnvFont.getFont(name, family);
        if (font == null) {
            font = defaultFont;
        }
        font = font.deriveFont((float)size);
        return font.getStringBounds(str, EnvFont.FRCtx());
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(Font defaultFont) {
        EnvFont.defaultFont = defaultFont;
    }

    public static void setDefaultFont(Path path) throws IOException, FontFormatException {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return;
        }
        defaultFont = Font.createFont(0, path.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FontRenderContext FRCtx() {
        if (frCtx != null) return frCtx;
        Class<EnvFont> clazz = EnvFont.class;
        synchronized (EnvFont.class) {
            frCtx = new FontRenderContext(new AffineTransform(), true, true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return frCtx;
        }
    }
}

