/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.signatures.sig;

import java.util.List;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.signatures.sig.Parameter;

public class Parameters
extends OFDElement {
    public Parameters(Element proxy) {
        super(proxy);
    }

    public Parameters() {
        super("Parameters");
    }

    public Parameters addParameter(@Nullable Parameter parameter) {
        if (parameter == null) {
            return this;
        }
        String name = parameter.getNameAttr();
        Parameter oldP = this.getParameter(name);
        if (oldP != null) {
            this.remove(oldP);
        }
        this.add(parameter);
        return this;
    }

    public Parameters addParameter(@NotNull String name, String value) {
        Parameter parameter = new Parameter(name, value);
        return this.addParameter(parameter);
    }

    public Parameters addParameter(@NotNull String name, String type, String value) {
        Parameter parameter = new Parameter(name, type, value);
        return this.addParameter(parameter);
    }

    @Nullable
    public Parameter removeParameter(@Nullable String name) {
        if (name == null) {
            return null;
        }
        Parameter oldP = this.getParameter(name);
        if (oldP != null) {
            this.remove(oldP);
        }
        return oldP;
    }

    @Nullable
    public Parameter getParameter(@NotNull String name) {
        List<Parameter> pList = this.getParameters();
        for (Parameter p : pList) {
            if (!name.equals(p.getNameAttr())) continue;
            return p;
        }
        return null;
    }

    public List<Parameter> getParameters() {
        return this.getOFDElements("Parameter", Parameter::new);
    }
}

