/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.graph.tight.method;

import java.io.Serializable;
import org.dom4j.Element;
import org.ofdrw.core.basicType.STBase;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Pos;
import org.ofdrw.core.graph.tight.method.Command;

public class Arc
extends Command {
    public Arc(Element proxy) {
        super(proxy);
    }

    public Arc() {
        super("Arc");
    }

    public Arc(double rx, double ry, double angle, double large, double sweep, double x, double y) {
        this();
        this.setEllipseSize(rx, ry);
        this.setRotationAngle(angle);
        this.setLargeArc(large != 0.0);
        this.setSweepDirection(sweep != 0.0);
        this.setEndPoint(x, y);
    }

    public Arc setSweepDirection(boolean sweepDirection) {
        this.addAttribute("SweepDirection", Boolean.toString(sweepDirection));
        return this;
    }

    public Boolean getSweepDirection() {
        return Boolean.parseBoolean(this.attributeValue("SweepDirection"));
    }

    public Arc setLargeArc(boolean largeArc) {
        this.addAttribute("LargeArc", Boolean.toString(largeArc));
        return this;
    }

    public Boolean getLargeArc() {
        return Boolean.parseBoolean(this.attributeValue("LargeArc"));
    }

    public Arc setRotationAngle(double rotationAngle) {
        this.addAttribute("RotationAngle", STBase.fmt(rotationAngle %= 360.0));
        return this;
    }

    public Double getRotationAngle() {
        double res = Double.parseDouble(this.attributeValue("RotationAngle"));
        return res % 360.0;
    }

    public Arc setEllipseSize(ST_Array ellipseSize) {
        if (ellipseSize == null) {
            throw new IllegalArgumentException("ellipseSize \u4e0d\u80fd\u4e3anull");
        }
        this.addAttribute("EllipseSize", ellipseSize.toString());
        return this;
    }

    public Arc setEllipseSize(double ... sizes) {
        return this.setEllipseSize(new ST_Array(new Serializable[]{sizes}));
    }

    public ST_Array getEllipseSize() {
        return ST_Array.getInstance(this.attributeValue("EllipseSize"));
    }

    public Arc setEndPoint(ST_Pos endPoint) {
        this.addAttribute("EndPoint", endPoint.toString());
        return this;
    }

    public Arc setEndPoint(double x, double y) {
        return this.setEndPoint(new ST_Pos(x, y));
    }

    public ST_Pos getEndPoint() {
        return ST_Pos.getInstance(this.attributeValue("EndPoint"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("A ");
        ST_Array ellipseSize = this.getEllipseSize();
        if (ellipseSize != null) {
            sb.append(ellipseSize.toString()).append(" ");
        } else {
            sb.append("0 0 ");
        }
        try {
            sb.append(this.getRotationAngle()).append(" ");
        }
        catch (NumberFormatException e) {
            sb.append("0 ");
        }
        if (this.getLargeArc().booleanValue()) {
            sb.append("1 ");
        } else {
            sb.append("0 ");
        }
        if (this.getSweepDirection().booleanValue()) {
            sb.append("1 ");
        } else {
            sb.append("0 ");
        }
        ST_Pos endPoint = this.getEndPoint();
        if (endPoint != null) {
            sb.append(endPoint.toString());
        } else {
            sb.append("0 0");
        }
        return sb.toString();
    }
}

