/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.basicType;

import java.util.ArrayList;
import org.dom4j.Element;
import org.ofdrw.core.basicType.STBase;

public class ST_Loc
extends STBase {
    private String loc;

    public ST_Loc(String path) {
        this.loc = path;
    }

    public static ST_Loc getInstance(String loc) {
        if (loc == null || loc.trim().length() == 0) {
            return null;
        }
        return new ST_Loc(loc.trim());
    }

    public static ST_Loc getInstance(Element e) {
        if (e == null) {
            return null;
        }
        return ST_Loc.getInstance(e.getTextTrim());
    }

    public String getLoc() {
        return this.loc;
    }

    public ST_Loc setLoc(String loc) {
        this.loc = loc;
        return this;
    }

    public String[] split() {
        if (this.loc == null) {
            return new String[0];
        }
        return this.loc.split("/");
    }

    public String[] parts() {
        if (this.loc == null) {
            return new String[0];
        }
        String[] split = this.loc.split("/");
        ArrayList<String> paths = new ArrayList<String>();
        for (String s : split) {
            if (s == null || s.trim().length() <= 0) continue;
            paths.add(s);
        }
        return paths.toArray(new String[0]);
    }

    public String parent() {
        int indexOf = this.loc.lastIndexOf(47);
        if (indexOf == -1) {
            return "";
        }
        return this.loc.substring(0, indexOf);
    }

    public ST_Loc parentLoc() {
        return new ST_Loc(this.parent());
    }

    public String getFileName() {
        int indexOf = this.loc.lastIndexOf(47);
        if (indexOf == -1) {
            return this.loc;
        }
        if (indexOf == this.loc.length() - 1) {
            return "";
        }
        return this.loc.substring(indexOf + 1);
    }

    public ST_Loc cat(String p2) {
        if (p2 == null) {
            return this;
        }
        String part1 = this.loc;
        if (part1.endsWith("/")) {
            part1 = part1.substring(0, part1.length() - 1);
        }
        if (p2.startsWith("/")) {
            p2 = p2.substring(1);
        }
        return new ST_Loc(part1 + "/" + p2);
    }

    public ST_Loc cat(ST_Loc loc) {
        if (loc == null) {
            return this;
        }
        return this.cat(loc.getLoc());
    }

    public boolean endWith(String suffix) {
        return this.loc.endsWith(suffix);
    }

    public boolean startWith(String prefix) {
        return this.loc.startsWith(prefix);
    }

    public boolean isRootPath() {
        return this.loc.startsWith("/");
    }

    public boolean isEmpty() {
        return this.loc == null || this.loc.trim().length() == 0;
    }

    public String toString() {
        return this.loc;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.loc.equals(obj);
        }
        if (obj instanceof ST_Loc) {
            return this.loc.equals(((ST_Loc)obj).loc);
        }
        return this.loc.equals(obj.toString());
    }

    public static boolean equal(Object a, Object b) {
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof ST_Loc && b instanceof ST_Loc) {
            return ((ST_Loc)a).loc.equals(((ST_Loc)b).loc);
        }
        String aStr = a.toString();
        String bStr = b.toString();
        return aStr.equals(bStr);
    }
}

