/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.basicType;

import java.io.Serializable;
import java.util.function.Function;
import org.ofdrw.core.OFDSimpleTypeElement;

public abstract class STBase
implements Serializable {
    public static int MAX_KEEP_DECIMAL = 3;

    public OFDSimpleTypeElement getElement(String name) {
        return new OFDSimpleTypeElement(name, (Serializable)((Object)this.toString()));
    }

    public static String fmt(double d) {
        if (d == (double)((long)d)) {
            return String.format("%d", (long)d);
        }
        if (-1.0 < d && d < 1.0) {
            String str = String.format("%.8f", d);
            if (str.equals("0.00000000")) {
                return "0";
            }
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (c - 48 <= 0) continue;
                if (i + MAX_KEEP_DECIMAL <= len) {
                    return str.substring(0, i + MAX_KEEP_DECIMAL);
                }
                return str.substring(0, len);
            }
            return str;
        }
        return String.format("%." + MAX_KEEP_DECIMAL + "f", d);
    }

    public static Double toDouble(String str) {
        Double res = STBase.num(str, Double::parseDouble);
        return res == null ? 0.0 : res;
    }

    public static Integer toInt(String str) {
        Integer res = STBase.num(str, Integer::parseInt);
        return res == null ? 0 : res;
    }

    private static <R extends Number> R num(String str, Function<String, R> mapper) {
        Number res = null;
        try {
            res = (Number)mapper.apply(str);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            for (char c : str.toCharArray()) {
                if (c == '-' || c == '+' || c == '.') {
                    sb.append(c);
                    continue;
                }
                if ('0' > c || c > '9') continue;
                sb.append(c);
            }
            try {
                res = (Number)mapper.apply(sb.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (R)res;
    }
}

