/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.versions;

import java.time.LocalDate;
import org.dom4j.Element;
import org.ofdrw.core.Const;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.versions.FileList;

public class DocVersion
extends OFDElement {
    public DocVersion(Element proxy) {
        super(proxy);
    }

    public DocVersion() {
        super("DocVersion");
    }

    public DocVersion(String id, FileList fileList) {
        this();
        this.setID(id).setFileList(fileList);
    }

    public DocVersion setID(String id) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException("\u7248\u672c\u6807\u8bc6\u7b26\uff08ID\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.addAttribute("ID", id.toString());
        return this;
    }

    public String getID() {
        String str = this.attributeValue("ID");
        if (str == null || str.trim().length() == 0) {
            throw new IllegalArgumentException("\u7248\u672c\u6807\u8bc6\u7b26\uff08ID\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return str;
    }

    public DocVersion setVersion(String version) {
        if (version == null) {
            this.removeAttr(version);
            return this;
        }
        this.addAttribute("Version", version);
        return this;
    }

    public String getVersion() {
        return this.attributeValue("Version");
    }

    public DocVersion setDocVersionName(String name) {
        if (name == null) {
            this.removeAttr("Name");
            return this;
        }
        this.addAttribute("Name", name);
        return this;
    }

    public String getDocVersionName() {
        return this.attributeValue("Name");
    }

    public DocVersion setCreationDate(LocalDate creationDate) {
        if (creationDate == null) {
            this.removeAttr("CreationDate");
            return this;
        }
        this.addAttribute("CreationDate", creationDate.toString());
        return this;
    }

    public LocalDate getCreationDate() {
        String dateStr = this.getOFDElementText("CreationDate");
        return dateStr != null ? LocalDate.parse(dateStr, Const.DATE_FORMATTER) : null;
    }

    public DocVersion setFileList(FileList fileList) {
        if (fileList == null) {
            throw new IllegalArgumentException("\u7248\u672c\u5305\u542b\u7684\u6587\u4ef6\u5217\u8868\uff08FileList\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.add(fileList);
        return this;
    }

    public FileList getFileList() {
        Element e = this.getOFDElement("FileList");
        return e == null ? null : new FileList(e);
    }

    public DocVersion setDocRoot(ST_Loc docRoot) {
        if (docRoot == null) {
            throw new IllegalArgumentException("\u8be5\u7248\u672c\u7684\u5165\u53e3\u6587\u4ef6\uff08DocRoot\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.addOFDEntity("DocRoot", docRoot);
        return this;
    }

    public ST_Loc getDocRoot() {
        Element e = this.getOFDElement("DocRoot");
        return e == null ? null : new ST_Loc(e.getTextTrim());
    }
}

