/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.ofdconverter;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.converter.ofdconverter.DocConverter;
import org.ofdrw.layout.OFDDoc;
import org.ofdrw.layout.PageLayout;
import org.ofdrw.layout.VirtualPage;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.element.Img;
import org.ofdrw.layout.element.Position;

public class ImageConverter
implements DocConverter {
    final OFDDoc ofdDoc;
    private boolean closed = false;
    double ppm = 15.0;

    public ImageConverter(Path ofdPath) throws IOException {
        if (ofdPath == null) {
            throw new IllegalArgumentException("\u8f6c\u6362\u540e\u7684OFD\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (!Files.exists(ofdPath = ofdPath.toAbsolutePath(), new LinkOption[0])) {
            Path parent = ofdPath.getParent();
            if (Files.exists(parent, new LinkOption[0])) {
                if (!Files.isDirectory(parent, new LinkOption[0])) {
                    throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6: " + parent);
                }
            } else {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.createFile(ofdPath, new FileAttribute[0]);
        }
        this.ofdDoc = new OFDDoc(ofdPath);
    }

    public ImageConverter(OutputStream output) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("\u8f6c\u6362\u540e\u7684OFD\u6d41\u4e3a\u7a7a");
        }
        this.ofdDoc = new OFDDoc(output);
    }

    @Override
    public void convert(Path filepath, int ... indexes) throws GeneralConvertException {
        if (filepath == null || !Files.exists(filepath, new LinkOption[0]) || Files.isDirectory(filepath, new LinkOption[0])) {
            return;
        }
        PageLayout pageLayout = this.ofdDoc.getPageLayout();
        double pageWidth = pageLayout.getWidth();
        double pageHeight = pageLayout.getHeight();
        double width = 50.0;
        double height = 50.0;
        try {
            BufferedImage image = Img.readImage((File)filepath.toFile());
            if (image != null) {
                width = (double)image.getWidth() / this.ppm;
                height = (double)image.getHeight() / this.ppm;
                double scale = 1.0;
                if (width > pageWidth) {
                    scale = pageWidth / width;
                }
                if (height > pageHeight && pageHeight / height > scale) {
                    scale = pageHeight / height;
                }
                width *= scale;
                height *= scale;
            }
            VirtualPage page = new VirtualPage(pageLayout);
            Img item = new Img(width, height, filepath);
            item.setPosition(Position.Absolute);
            double x = (pageWidth - width) / 2.0;
            double y = (pageHeight - height) / 2.0;
            item.setXY(Double.valueOf(x), Double.valueOf(y));
            page.add((Div)item);
            this.ofdDoc.addVPage(page);
        }
        catch (IOException e) {
            throw new GeneralConvertException("\u56fe\u7247\u8f6c\u6362OFD\u5f02\u5e38", e);
        }
    }

    public void append(Path filepath, double width, double height) {
        try {
            PageLayout pageLayout = this.ofdDoc.getPageLayout();
            double pageWidth = pageLayout.getWidth();
            double pageHeight = pageLayout.getHeight();
            VirtualPage page = new VirtualPage(pageLayout);
            Img item = new Img(width, height, filepath);
            item.setPosition(Position.Absolute);
            double x = (pageWidth - width) / 2.0;
            double y = (pageHeight - height) / 2.0;
            item.setXY(Double.valueOf(x), Double.valueOf(y));
            page.add((Div)item);
            this.ofdDoc.addVPage(page);
        }
        catch (IOException e) {
            throw new GeneralConvertException("\u56fe\u7247\u8f6c\u6362OFD\u5f02\u5e38", e);
        }
    }

    public void setPPM(double ppm) {
        if (ppm <= 0.0) {
            throw new IllegalArgumentException("PPM\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        this.ppm = ppm;
    }

    public void setPageSize(PageLayout pageLayout) {
        this.ofdDoc.setDefaultPageLayout(pageLayout);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.ofdDoc != null) {
            this.ofdDoc.close();
        }
    }
}

