/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.export;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.converter.ImageMaker;
import org.ofdrw.converter.export.OFDExporter;
import org.ofdrw.reader.OFDReader;

public class ImageExporter
implements OFDExporter {
    final OFDReader ofdReader;
    final ImageMaker imageMaker;
    final String imageType;
    final Path outDirPath;
    List<Path> imgFileArr;
    private boolean closed = false;

    public ImageExporter(Path ofdFilePath, Path imgDirPath) throws IOException {
        this(ofdFilePath, imgDirPath, "PNG", 15.0);
    }

    public ImageExporter(InputStream ofdInput, Path imgDirPath) throws IOException {
        this(ofdInput, imgDirPath, "PNG", 15.0);
    }

    public ImageExporter(Path ofdFilePath, Path imgDirPath, String imageType, double ppm) throws IOException {
        this.ofdReader = new OFDReader(ofdFilePath);
        if (imgDirPath == null) {
            throw new IllegalArgumentException("\u5bfc\u51fa\u56fe\u7247\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (Files.exists(imgDirPath = imgDirPath.toAbsolutePath(), new LinkOption[0]) && !Files.isDirectory(imgDirPath, new LinkOption[0])) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6");
        }
        if (!Files.exists(imgDirPath, new LinkOption[0])) {
            Files.createDirectories(imgDirPath, new FileAttribute[0]);
        }
        this.imageMaker = new ImageMaker(this.ofdReader, ppm);
        this.imageMaker.config.setDrawBoundary(false);
        this.imageType = imageType;
        this.imgFileArr = new ArrayList<Path>();
        this.outDirPath = imgDirPath;
    }

    public ImageExporter(InputStream ofdInput, Path imgDirPath, String imageType, double ppm) throws IOException {
        this.ofdReader = new OFDReader(ofdInput);
        if (imgDirPath == null) {
            throw new IllegalArgumentException("\u5bfc\u51fa\u56fe\u7247\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (Files.exists(imgDirPath = imgDirPath.toAbsolutePath(), new LinkOption[0]) && !Files.isDirectory(imgDirPath, new LinkOption[0])) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6");
        }
        if (!Files.exists(imgDirPath, new LinkOption[0])) {
            Files.createDirectories(imgDirPath, new FileAttribute[0]);
        }
        this.imageMaker = new ImageMaker(this.ofdReader, ppm);
        this.imageMaker.config.setDrawBoundary(false);
        this.imageType = imageType;
        this.imgFileArr = new ArrayList<Path>();
        this.outDirPath = imgDirPath;
    }

    @Override
    public void export(int ... indexes) throws GeneralConvertException {
        LinkedList<Integer> targetPages = new LinkedList<Integer>();
        if (indexes == null || indexes.length == 0) {
            for (int i = 0; i < this.ofdReader.getNumberOfPages(); ++i) {
                targetPages.add(i);
            }
        } else {
            int maxPageIndex = this.ofdReader.getNumberOfPages();
            for (int index : indexes) {
                if (index < 0 || index >= maxPageIndex) continue;
                targetPages.add(index);
            }
        }
        try {
            for (Integer index : targetPages) {
                BufferedImage image = this.imageMaker.makePage(index);
                Path dst = this.outDirPath.resolve(this.imgFileArr.size() + "." + this.imageType.toLowerCase());
                ImageIO.write((RenderedImage)image, this.imageType, dst.toFile());
                this.imgFileArr.add(dst);
            }
        }
        catch (IOException e) {
            throw new GeneralConvertException("\u56fe\u7247\u8f6c\u6362\u5f02\u5e38", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.ofdReader != null) {
            this.ofdReader.close();
        }
    }

    public List<Path> getImgFilePaths() {
        return this.imgFileArr;
    }

    public String getImageType() {
        return this.imageType;
    }

    public void setPPM(double ppm) {
        if (this.imageMaker == null) {
            return;
        }
        this.imageMaker.setPPM(ppm);
    }
}

