/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.export;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.converter.HtmlMaker;
import org.ofdrw.converter.SVGMaker;
import org.ofdrw.converter.export.OFDExporter;
import org.ofdrw.reader.OFDReader;

public class HTMLExporter
implements OFDExporter {
    final OFDReader ofdReader;
    final HtmlMaker htmlMaker;
    final SVGMaker svgMaker;
    final OutputStream output;
    byte[] header = "<!DOCTYPE html>\n<html lang=\"en\">\n\n<head>\n  <meta charset=\"UTF-8\">\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  <title>\u6587\u4ef6\u9884\u89c8</title>\n</head>\n<body style=\"margin: 0;background: #E6E8EB;height: 100%\">\n  <div style=\"display: flex; flex-direction: column;align-items: center;\">    <div style=\"height: 10px;\"></div>".getBytes(StandardCharsets.UTF_8);
    byte[] booter = "  </div>\n</body>\n</html>".getBytes(StandardCharsets.UTF_8);
    byte[] margin_bottom = "<div style=\"height: 10px;\"></div>".getBytes(StandardCharsets.UTF_8);
    private boolean closed = false;

    public HTMLExporter(Path ofdFilePath, Path htmlFilePath) throws IOException {
        if (htmlFilePath == null) {
            throw new IllegalArgumentException("\u5bfc\u51faHTML\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (!Files.exists(htmlFilePath = htmlFilePath.toAbsolutePath(), new LinkOption[0])) {
            Path parent = htmlFilePath.getParent();
            if (Files.exists(parent, new LinkOption[0])) {
                if (!Files.isDirectory(parent, new LinkOption[0])) {
                    throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6: " + parent);
                }
            } else {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.createFile(htmlFilePath, new FileAttribute[0]);
        }
        this.ofdReader = new OFDReader(ofdFilePath);
        this.htmlMaker = new HtmlMaker(this.ofdReader, 1000);
        this.svgMaker = new SVGMaker(this.ofdReader, 0);
        this.output = Files.newOutputStream(htmlFilePath, new OpenOption[0]);
        this.svgMaker.config.setDrawBoundary(false);
        this.svgMaker.config.setClip(false);
        this.output.write(this.header);
    }

    public HTMLExporter(InputStream ofdInput, OutputStream htmlOutput) throws IOException {
        if (ofdInput == null) {
            throw new IllegalArgumentException("OFD\u6d41\u4e3a\u7a7a");
        }
        if (htmlOutput == null) {
            throw new IllegalArgumentException("HTML\u6d41\u4e3a\u7a7a");
        }
        this.ofdReader = new OFDReader(ofdInput);
        this.htmlMaker = new HtmlMaker(this.ofdReader, 1000);
        this.svgMaker = new SVGMaker(this.ofdReader, 0);
        this.svgMaker.config.setDrawBoundary(false);
        this.svgMaker.config.setClip(false);
        this.output = htmlOutput;
        this.output.write(this.header);
    }

    @Override
    public void export(int ... indexes) throws GeneralConvertException {
        LinkedList<Integer> targetPages = new LinkedList<Integer>();
        if (indexes == null || indexes.length == 0) {
            for (int i = 0; i < this.ofdReader.getNumberOfPages(); ++i) {
                targetPages.add(i);
            }
        } else {
            int maxPageIndex = this.ofdReader.getNumberOfPages();
            for (int index : indexes) {
                if (index < 0 || index >= maxPageIndex) continue;
                targetPages.add(index);
            }
        }
        try {
            for (Integer index : targetPages) {
                String pageDiv = this.htmlMaker.makePageDiv(this.svgMaker, index);
                this.output.write(pageDiv.getBytes(StandardCharsets.UTF_8));
                this.output.write(this.margin_bottom);
            }
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("\u6587\u4ef6\u8f6c\u6362\u6216\u6587\u4ef6\u5199\u5165\u5f02\u5e38", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.ofdReader != null) {
            this.ofdReader.close();
        }
        if (this.output != null) {
            this.output.write(this.booter);
            this.output.close();
        }
    }
}

