/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType2;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType3;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.dom4j.Element;
import org.ofdrw.converter.FontLoader;
import org.ofdrw.converter.point.PathPoint;
import org.ofdrw.converter.point.TextCodePoint;
import org.ofdrw.converter.utils.CommonUtil;
import org.ofdrw.converter.utils.PointUtil;
import org.ofdrw.core.annotation.pageannot.Annot;
import org.ofdrw.core.attachment.CT_Attachment;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CompositeObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.PathObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicStructure.res.CT_MultiMedia;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_Pos;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.compositeObj.CT_VectorG;
import org.ofdrw.core.graph.pathObj.CT_Path;
import org.ofdrw.core.graph.pathObj.FillColor;
import org.ofdrw.core.graph.pathObj.Rule;
import org.ofdrw.core.graph.pathObj.StrokeColor;
import org.ofdrw.core.pageDescription.CT_GraphicUnit;
import org.ofdrw.core.pageDescription.clips.Area;
import org.ofdrw.core.pageDescription.clips.CT_Clip;
import org.ofdrw.core.pageDescription.color.color.CT_AxialShd;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.pageDescription.color.color.CT_RadialShd;
import org.ofdrw.core.pageDescription.color.color.ColorClusterType;
import org.ofdrw.core.pageDescription.color.color.Segment;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.signatures.appearance.StampAnnot;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.PageInfo;
import org.ofdrw.reader.ResourceLocator;
import org.ofdrw.reader.ResourceManage;
import org.ofdrw.reader.model.AnnotionEntity;
import org.ofdrw.reader.model.StampAnnotEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfboxMaker {
    private static final Logger logger = LoggerFactory.getLogger(PdfboxMaker.class);
    private final OFDReader reader;
    private final PDDocument pdf;
    private final ResourceManage resMgt;
    private Map<String, PDFont> fontCache = new HashMap<String, PDFont>();

    public PdfboxMaker(OFDReader reader, PDDocument pdf) throws IOException {
        this.reader = reader;
        this.pdf = pdf;
        this.resMgt = reader.getResMgt();
    }

    public PDPage makePage(PageInfo pageInfo) throws IOException {
        ST_Box pageBox = pageInfo.getSize();
        double pageWidthPixel = CommonUtil.converterDpi(pageBox.getWidth());
        double pageHeightPixel = CommonUtil.converterDpi(pageBox.getHeight());
        PDRectangle pageSize = new PDRectangle((float)pageWidthPixel, (float)pageHeightPixel);
        PDPage pdfPage = new PDPage(pageSize);
        this.pdf.addPage(pdfPage);
        List annotationEntities = this.reader.getAnnotationEntities();
        List stampAnnots = this.reader.getStampAnnots();
        try (PDPageContentStream contentStream = new PDPageContentStream(this.pdf, pdfPage);){
            List layerList = pageInfo.getAllLayer();
            this.writeLayer(this.resMgt, contentStream, layerList, pageBox, null);
            this.writeStamp(contentStream, pageInfo, stampAnnots);
            this.writeAnnoAppearance(this.resMgt, pageInfo, annotationEntities, contentStream, pageBox);
        }
        return pdfPage;
    }

    private void writeStamp(PDPageContentStream contentStream, PageInfo parent, List<StampAnnotEntity> stampAnnotEntityList) throws IOException {
        String pageID = parent.getId().toString();
        for (StampAnnotEntity stampAnnotVo : stampAnnotEntityList) {
            List stampAnnots = stampAnnotVo.getStampAnnots();
            for (StampAnnot stampAnnot : stampAnnots) {
                if (!stampAnnot.getPageRef().toString().equals(pageID)) continue;
                ST_Box pageBox = parent.getSize();
                ST_Box sealBox = stampAnnot.getBoundary();
                ST_Box clipBox = stampAnnot.getClip();
                if (stampAnnotVo.getImgType().equalsIgnoreCase("ofd")) {
                    OFDReader sealOfdReader = new OFDReader((InputStream)new ByteArrayInputStream(stampAnnotVo.getImageByte()));
                    Throwable throwable = null;
                    try {
                        ResourceManage sealResMgt = sealOfdReader.getResMgt();
                        for (PageInfo ofdPageVo : sealOfdReader.getPageList()) {
                            List layerList = ofdPageVo.getAllLayer();
                            this.writeLayer(sealResMgt, contentStream, layerList, pageBox, sealBox);
                            this.writeAnnoAppearance(sealResMgt, ofdPageVo, sealOfdReader.getAnnotationEntities(), contentStream, pageBox);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (sealOfdReader == null) continue;
                        if (throwable != null) {
                            try {
                                sealOfdReader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        sealOfdReader.close();
                        continue;
                    }
                }
                this.writeSealImage(contentStream, pageBox, stampAnnotVo.getImageByte(), sealBox, clipBox);
            }
        }
    }

    private void writeLayer(ResourceManage resMgt, PDPageContentStream contentStream, List<CT_Layer> layerList, ST_Box box, ST_Box sealBox) throws IOException {
        for (CT_Layer layer : layerList) {
            List pageBlockTypeList = layer.getPageBlocks();
            this.writePageBlock(resMgt, contentStream, box, sealBox, pageBlockTypeList, layer.getDrawParam(), null, null, null, null);
        }
    }

    private void writeAnnoAppearance(ResourceManage resMgt, PageInfo pageInfo, List<AnnotionEntity> annotionEntities, PDPageContentStream contentStream, ST_Box box) throws IOException {
        String pageId = pageInfo.getId().toString();
        for (AnnotionEntity annotionEntity : annotionEntities) {
            List annotList = annotionEntity.getAnnots();
            if (annotList == null || !pageId.equalsIgnoreCase(annotionEntity.getPageId())) continue;
            for (Annot annot : annotList) {
                List pageBlockTypeList = annot.getAppearance().getPageBlocks();
                ST_Box annotBox = annot.getAppearance().getBoundary();
                this.writePageBlock(resMgt, contentStream, box, null, pageBlockTypeList, null, annotBox, null, null, null);
            }
        }
    }

    private void writePageBlock(ResourceManage resMgt, PDPageContentStream contentStream, ST_Box box, ST_Box sealBox, List<PageBlockType> pageBlockTypeList, ST_RefID drawparam, ST_Box annotBox, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        PDColor defaultFillColor = new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
        PDColor defaultStrokeColor = new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
        float defaultLineWidth = 0.353f;
        CT_DrawParam ctDrawParam = null;
        if (drawparam != null) {
            ctDrawParam = resMgt.getDrawParamFinal(drawparam.toString());
        }
        if (ctDrawParam != null) {
            if (ctDrawParam.getLineWidth() != null) {
                defaultLineWidth = ctDrawParam.getLineWidth().floatValue();
            }
            if (ctDrawParam.getStrokeColor() != null) {
                defaultStrokeColor = CommonUtil.convertPDColor(ctDrawParam.getStrokeColor().getValue());
            }
            if (ctDrawParam.getFillColor() != null) {
                defaultFillColor = CommonUtil.convertPDColor(ctDrawParam.getFillColor().getValue());
            }
        }
        for (PageBlockType block : pageBlockTypeList) {
            if (block instanceof TextObject) {
                PDColor fillColor = defaultFillColor;
                TextObject textObject = (TextObject)block;
                resMgt.superDrawParam((CT_GraphicUnit)textObject);
                int alpha = 255;
                if (textObject.getFillColor() != null) {
                    if (textObject.getFillColor().getValue() != null) {
                        fillColor = CommonUtil.convertPDColor(textObject.getFillColor().getValue());
                    } else if (textObject.getFillColor().getColorByType() != null) {
                        CT_AxialShd ctAxialShd = (CT_AxialShd)textObject.getFillColor().getColorByType();
                        fillColor = CommonUtil.convertPDColor(((Segment)ctAxialShd.getSegments().get(0)).getColor().getValue());
                    }
                    alpha = textObject.getFillColor().getAlpha();
                }
                this.writeText(resMgt, contentStream, box, sealBox, textObject, fillColor, alpha);
                continue;
            }
            if (block instanceof ImageObject) {
                ImageObject imageObject = (ImageObject)block;
                resMgt.superDrawParam((CT_GraphicUnit)imageObject);
                this.writeImage(resMgt, contentStream, box, imageObject, annotBox);
                continue;
            }
            if (block instanceof PathObject) {
                PathObject pathObject = (PathObject)block;
                resMgt.superDrawParam((CT_GraphicUnit)pathObject);
                this.writePath(resMgt, contentStream, box, sealBox, annotBox, pathObject, defaultFillColor, defaultStrokeColor, defaultLineWidth, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
                continue;
            }
            if (block instanceof CompositeObject) {
                CompositeObject compositeObject = (CompositeObject)block;
                CT_VectorG vectorG = resMgt.getCompositeGraphicUnit(compositeObject.getResourceID().toString());
                Integer currentCompositeObjectAlpha = compositeObject.getAlpha();
                ST_Box currentCompositeObjectBoundary = compositeObject.getBoundary();
                ST_Array currentCompositeObjectCTM = compositeObject.getCTM();
                this.writePageBlock(resMgt, contentStream, box, sealBox, vectorG.getContent().getPageBlocks(), drawparam, annotBox, currentCompositeObjectAlpha, currentCompositeObjectBoundary, currentCompositeObjectCTM);
                continue;
            }
            if (!(block instanceof CT_PageBlock)) continue;
            this.writePageBlock(resMgt, contentStream, box, sealBox, ((CT_PageBlock)block).getPageBlocks(), drawparam, annotBox, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
        }
    }

    private PDShading parseAxial(Element eleAxialShd, ResourceManage resMgt, ST_Box box, PathObject pathObject) {
        PDShadingType2 result = null;
        if (eleAxialShd == null) {
            return result;
        }
        CT_AxialShd ctAxialShd = new CT_AxialShd(eleAxialShd);
        PDColor startColor = CommonUtil.convertPDColor(((Segment)ctAxialShd.getSegments().get(0)).getColor().getValue());
        PDColor endColor = CommonUtil.convertPDColor(((Segment)ctAxialShd.getSegments().get(ctAxialShd.getSegments().size() - 1)).getColor().getValue());
        ST_Pos startPos = ctAxialShd.getStartPoint();
        ST_Pos endPos = ctAxialShd.getEndPoint();
        double x1 = startPos.getX();
        double y1 = startPos.getY();
        double x2 = endPos.getX();
        double y2 = endPos.getY();
        double[] realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x1, y1, pathObject.getBoundary());
        x1 = realPos[0];
        y1 = box.getHeight() - realPos[1];
        realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x2, y2, pathObject.getBoundary());
        x2 = realPos[0];
        y2 = box.getHeight() - realPos[1];
        COSDictionary fdict = new COSDictionary();
        fdict.setInt(COSName.FUNCTION_TYPE, 2);
        COSArray domain = new COSArray();
        domain.add((COSBase)COSInteger.ZERO);
        domain.add((COSBase)COSInteger.ONE);
        fdict.setItem(COSName.DOMAIN, (COSBase)domain);
        fdict.setItem(COSName.C0, (COSBase)startColor.toCOSArray());
        fdict.setItem(COSName.C1, (COSBase)endColor.toCOSArray());
        fdict.setInt(COSName.N, 1);
        PDFunctionType2 func = new PDFunctionType2((COSBase)fdict);
        PDShadingType2 axialShading = new PDShadingType2(new COSDictionary());
        axialShading.setColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
        axialShading.setShadingType(2);
        COSArray coords1 = new COSArray();
        coords1.add((COSBase)new COSFloat((float)CommonUtil.converterDpi(x1)));
        coords1.add((COSBase)new COSFloat((float)CommonUtil.converterDpi(y1)));
        coords1.add((COSBase)new COSFloat((float)CommonUtil.converterDpi(x2)));
        coords1.add((COSBase)new COSFloat((float)CommonUtil.converterDpi(y2)));
        axialShading.setCoords(coords1);
        axialShading.setFunction((PDFunction)func);
        result = axialShading;
        return result;
    }

    private PDShading parseRadial(Element eleRadialShd, ResourceManage resMgt, ST_Box box, PathObject pathObject) {
        PDShadingType3 result = null;
        if (eleRadialShd == null) {
            return result;
        }
        CT_RadialShd ctRadialShd = new CT_RadialShd(eleRadialShd);
        PDColor startColor = CommonUtil.convertPDColor(((Segment)ctRadialShd.getSegments().get(0)).getColor().getValue());
        PDColor endColor = CommonUtil.convertPDColor(((Segment)ctRadialShd.getSegments().get(ctRadialShd.getSegments().size() - 1)).getColor().getValue());
        ST_Pos startPos = ctRadialShd.getStartPoint();
        ST_Pos endPos = ctRadialShd.getEndPoint();
        double x1 = startPos.getX();
        double y1 = startPos.getY();
        double x2 = endPos.getX();
        double y2 = endPos.getY();
        double[] realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x1, y1, pathObject.getBoundary());
        x1 = realPos[0];
        y1 = box.getHeight() - realPos[1];
        realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x2, y2, pathObject.getBoundary());
        x2 = realPos[0];
        y2 = box.getHeight() - realPos[1];
        COSDictionary fdict = new COSDictionary();
        fdict.setInt(COSName.FUNCTION_TYPE, 2);
        COSArray domain = new COSArray();
        domain.add((COSBase)COSInteger.ZERO);
        domain.add((COSBase)COSInteger.ONE);
        fdict.setItem(COSName.DOMAIN, (COSBase)domain);
        fdict.setItem(COSName.C0, (COSBase)startColor.toCOSArray());
        fdict.setItem(COSName.C1, (COSBase)endColor.toCOSArray());
        fdict.setInt(COSName.N, 1);
        PDFunctionType2 func = new PDFunctionType2((COSBase)fdict);
        PDShadingType3 radialShading = new PDShadingType3(new COSDictionary());
        radialShading.setColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
        radialShading.setShadingType(3);
        COSArray coords1 = new COSArray();
        coords1.add((COSBase)new COSFloat((float)CommonUtil.converterDpi(x1)));
        coords1.add((COSBase)new COSFloat((float)CommonUtil.converterDpi(y1)));
        coords1.add((COSBase)new COSFloat((float)CommonUtil.converterDpi(ctRadialShd.getStartRadius())));
        coords1.add((COSBase)new COSFloat((float)CommonUtil.converterDpi(x2)));
        coords1.add((COSBase)new COSFloat((float)CommonUtil.converterDpi(y2)));
        coords1.add((COSBase)new COSFloat((float)CommonUtil.converterDpi(ctRadialShd.getEndRadius())));
        radialShading.setCoords(coords1);
        radialShading.setFunction((PDFunction)func);
        result = radialShading;
        return result;
    }

    private PDShading parseShading(CT_Color color, ST_Box box, PathObject pathObject) {
        PDShading radialShading;
        PDShading shading = null;
        if (color == null) {
            return shading;
        }
        PDShading axialShading = this.parseAxial(color.getOFDElement("AxialShd"), this.resMgt, box, pathObject);
        if (axialShading != null) {
            shading = axialShading;
        }
        if ((radialShading = this.parseRadial(color.getOFDElement("RadialShd"), this.resMgt, box, pathObject)) != null) {
            shading = radialShading;
        }
        return shading;
    }

    private void writePath(ResourceManage resMgt, PDPageContentStream contentStream, ST_Box box, ST_Box sealBox, ST_Box annotBox, PathObject pathObject, PDColor defaultFillColor, PDColor defaultStrokeColor, float defaultLineWidth, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        PDExtendedGraphicsState graphicsState;
        StrokeColor strokeColor;
        contentStream.saveGraphicsState();
        double scale = this.scaling(sealBox, (CT_GraphicUnit)pathObject);
        CT_DrawParam ctDrawParam = resMgt.superDrawParam((CT_GraphicUnit)pathObject);
        if (ctDrawParam != null) {
            if (pathObject.getStrokeColor() == null && ctDrawParam.getStrokeColor() != null) {
                pathObject.setStrokeColor(ctDrawParam.getStrokeColor());
            }
            if (pathObject.getFillColor() == null && ctDrawParam.getFillColor() != null) {
                pathObject.setFillColor((CT_Color)ctDrawParam.getFillColor());
            }
            if (pathObject.getLineWidth() == null && ctDrawParam.getLineWidth() != null) {
                pathObject.setLineWidth(ctDrawParam.getLineWidth());
            }
        }
        if ((strokeColor = pathObject.getStrokeColor()) != null) {
            if (strokeColor.getValue() != null) {
                contentStream.setStrokingColor(CommonUtil.convertPDColor(strokeColor.getValue()));
            } else {
                this.setShadingFill(contentStream, (CT_Color)strokeColor, false);
            }
        } else {
            contentStream.setStrokingColor(defaultStrokeColor);
        }
        float lineWidth = defaultLineWidth;
        if (pathObject.getLineWidth() != null && pathObject.getLineWidth() > 0.0) {
            lineWidth = Double.valueOf(CommonUtil.converterDpi(pathObject.getLineWidth()) * scale).floatValue();
        }
        contentStream.setLineWidth(lineWidth);
        if (pathObject.getCTM() != null && pathObject.getLineWidth() != null) {
            Double[] ctm = pathObject.getCTM().toDouble();
            double a = ctm[0];
            double b = ctm[1];
            double c = ctm[2];
            double d = ctm[3];
            double e = ctm[4];
            double f = ctm[5];
            double sx = Math.signum(a) * Math.sqrt(a * a + c * c);
            double sy = Math.signum(d) * Math.sqrt(b * b + d * d);
            lineWidth = (float)((double)lineWidth * sx);
        }
        if (pathObject.getStroke().booleanValue()) {
            PDShading shading;
            if (compositeObjectAlpha != null) {
                graphicsState = new PDExtendedGraphicsState();
                graphicsState.setStrokingAlphaConstant(Float.valueOf((float)compositeObjectAlpha.intValue() * 1.0f / 255.0f));
                contentStream.setGraphicsStateParameters(graphicsState);
            }
            if (pathObject.getDashPattern() != null) {
                float unitsOn = (float)CommonUtil.converterDpi(pathObject.getDashPattern().toDouble()[0].floatValue());
                float unitsOff = (float)CommonUtil.converterDpi(pathObject.getDashPattern().toDouble()[1].floatValue());
                float phase = (float)CommonUtil.converterDpi(pathObject.getDashOffset().floatValue());
                contentStream.setLineDashPattern(new float[]{unitsOn, unitsOff}, phase);
            }
            contentStream.setLineJoinStyle(pathObject.getJoin().ordinal());
            contentStream.setLineCapStyle(pathObject.getCap().ordinal());
            contentStream.setMiterLimit(pathObject.getMiterLimit().floatValue());
            this.path(contentStream, box, sealBox, annotBox, pathObject, compositeObjectBoundary, compositeObjectCTM);
            if (pathObject.getLineWidth() != null && pathObject.getLineWidth() > 0.0) {
                contentStream.setLineWidth(pathObject.getLineWidth().floatValue());
            }
            if ((shading = this.parseShading((CT_Color)strokeColor, box, pathObject)) != null) {
                contentStream.clip();
                contentStream.shadingFill(shading);
            }
            contentStream.stroke();
            contentStream.restoreGraphicsState();
        }
        if (pathObject.getFill().booleanValue()) {
            FillColor fillColor;
            contentStream.saveGraphicsState();
            if (compositeObjectAlpha != null) {
                graphicsState = new PDExtendedGraphicsState();
                graphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)compositeObjectAlpha.intValue() * 1.0f / 255.0f));
                contentStream.setGraphicsStateParameters(graphicsState);
            }
            if ((fillColor = (FillColor)pathObject.getFillColor()) != null) {
                if (fillColor.getValue() != null) {
                    contentStream.setNonStrokingColor(CommonUtil.convertPDColor(fillColor.getValue()));
                } else {
                    this.setShadingFill(contentStream, (CT_Color)fillColor, true);
                }
            } else {
                contentStream.setNonStrokingColor(defaultFillColor);
            }
            this.path(contentStream, box, sealBox, annotBox, pathObject, compositeObjectBoundary, compositeObjectCTM);
            PDShading shading = this.parseShading((CT_Color)fillColor, box, pathObject);
            if (shading != null) {
                contentStream.clip();
                contentStream.shadingFill(shading);
            }
            if (pathObject.getRule() != null && pathObject.getRule().equals((Object)Rule.Even_Odd)) {
                contentStream.fillEvenOdd();
            } else {
                contentStream.fill();
            }
            contentStream.restoreGraphicsState();
        }
    }

    private void setShadingFill(PDPageContentStream contentStream, CT_Color ctColor, boolean isFill) throws IOException {
        ColorClusterType color = ctColor.getColor();
        if (!(color instanceof CT_AxialShd)) {
            return;
        }
        CT_AxialShd ctAxialShd = (CT_AxialShd)color;
        ST_Array start = ((Segment)ctAxialShd.getSegments().get(0)).getColor().getValue();
        ST_Array end = ((Segment)ctAxialShd.getSegments().get(ctAxialShd.getSegments().size() - 1)).getColor().getValue();
        ST_Pos startPos = ctAxialShd.getStartPoint();
        ST_Pos endPos = ctAxialShd.getEndPoint();
        if (isFill) {
            contentStream.setNonStrokingColor(CommonUtil.convertPDColor(end));
        } else {
            contentStream.setStrokingColor(CommonUtil.convertPDColor(end));
        }
    }

    private void path(PDPageContentStream contentStream, ST_Box box, ST_Box sealBox, ST_Box annotBox, PathObject pathObject, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        if (pathObject.getBoundary() == null) {
            return;
        }
        double scale = this.scaling(sealBox, (CT_GraphicUnit)pathObject);
        if (sealBox != null) {
            pathObject.setBoundary(pathObject.getBoundary().getTopLeftX() + sealBox.getTopLeftX(), pathObject.getBoundary().getTopLeftY() + sealBox.getTopLeftY(), pathObject.getBoundary().getWidth().doubleValue(), pathObject.getBoundary().getHeight().doubleValue());
        }
        if (annotBox != null) {
            pathObject.setBoundary(pathObject.getBoundary().getTopLeftX() + annotBox.getTopLeftX(), pathObject.getBoundary().getTopLeftY() + annotBox.getTopLeftY(), pathObject.getBoundary().getWidth().doubleValue(), pathObject.getBoundary().getHeight().doubleValue());
        }
        this.clip(contentStream, box, pathObject);
        List<PathPoint> listPoint = PointUtil.calPdfPathPoint(box.getWidth(), box.getHeight(), pathObject.getBoundary(), PointUtil.convertPathAbbreviatedDatatoPoint(pathObject.getAbbreviatedData()), pathObject.getCTM() != null, pathObject.getCTM(), compositeObjectBoundary, compositeObjectCTM, true, scale);
        for (int i = 0; i < listPoint.size(); ++i) {
            if (listPoint.get((int)i).type.equals("M") || listPoint.get((int)i).type.equals("S")) {
                contentStream.moveTo(listPoint.get((int)i).x1, listPoint.get((int)i).y1);
                continue;
            }
            if (listPoint.get((int)i).type.equals("L")) {
                contentStream.lineTo(listPoint.get((int)i).x1, listPoint.get((int)i).y1);
                continue;
            }
            if (listPoint.get((int)i).type.equals("B")) {
                contentStream.curveTo(listPoint.get((int)i).x1, listPoint.get((int)i).y1, listPoint.get((int)i).x2, listPoint.get((int)i).y2, listPoint.get((int)i).x3, listPoint.get((int)i).y3);
                continue;
            }
            if (listPoint.get((int)i).type.equals("Q")) {
                contentStream.curveTo1(listPoint.get((int)i).x1, listPoint.get((int)i).y1, listPoint.get((int)i).x2, listPoint.get((int)i).y2);
                continue;
            }
            if (!listPoint.get((int)i).type.equals("C")) continue;
            contentStream.closePath();
        }
    }

    private void clip(PDPageContentStream contentStream, ST_Box box, PathObject pathObject) throws IOException {
        if (pathObject.getClips() == null) {
            return;
        }
        List clips = pathObject.getClips().getClips();
        for (int k = 0; k < clips.size(); ++k) {
            CT_Clip clip = (CT_Clip)clips.get(k);
            contentStream.clip();
            for (Area area : clip.getAreas()) {
                Element elePath = area.getOFDElement("Path");
                CT_Path path = new CT_Path(elePath);
                List<PathPoint> points = PointUtil.calPdfPathPoint(box.getWidth(), box.getHeight(), pathObject.getBoundary(), PointUtil.convertPathAbbreviatedDatatoPoint(path.getAbbreviatedData()), area.getCTM() != null, area.getCTM(), null, null, true, 1.0);
                for (int i = 0; i < points.size(); ++i) {
                    PathPoint pathPoint = points.get(i);
                    if (pathPoint.type.equals("M") || pathPoint.type.equals("S")) {
                        contentStream.moveTo(pathPoint.x1, pathPoint.y1);
                        continue;
                    }
                    if (pathPoint.type.equals("L")) {
                        contentStream.lineTo(pathPoint.x1, pathPoint.y1);
                        continue;
                    }
                    if (pathPoint.type.equals("B")) {
                        contentStream.curveTo(pathPoint.x1, pathPoint.y1, pathPoint.x2, pathPoint.y2, pathPoint.x3, pathPoint.y3);
                        continue;
                    }
                    if (pathPoint.type.equals("Q")) {
                        contentStream.curveTo2(pathPoint.x1, pathPoint.y1, pathPoint.x2, pathPoint.y2);
                        continue;
                    }
                    if (!pathPoint.type.equals("C")) continue;
                    contentStream.closePath();
                }
            }
            contentStream.clip();
        }
    }

    private double scaling(ST_Box targetBox, ST_Box currentBox) {
        double scale = 1.0;
        if (targetBox != null && currentBox != null) {
            scale = Math.min(targetBox.getWidth() / currentBox.getWidth(), targetBox.getHeight() / currentBox.getHeight());
        }
        return scale;
    }

    private double scaling(ST_Box targetBox, CT_GraphicUnit graphicUnit) {
        double scale = 1.0;
        PageBlockType instance = PageBlockType.getInstance((Element)graphicUnit.getParent());
        if (instance != null && instance instanceof CT_PageBlock) {
            scale = this.scaling(targetBox, graphicUnit.getBoundary());
        }
        return scale;
    }

    private boolean isSameBox(ST_Box box1, ST_Box box2) {
        if (null == box1 || null == box2) {
            return false;
        }
        return box1.getTopLeftX().equals(box2.getTopLeftX()) && box1.getTopLeftY().equals(box2.getTopLeftY()) && box1.getWidth().equals(box2.getWidth()) && box1.getHeight().equals(box2.getHeight());
    }

    private void writeImage(ResourceManage resMgt, PDPageContentStream contentStream, ST_Box box, ImageObject imageObject, ST_Box annotBox) throws IOException {
        ST_RefID resourceID = imageObject.getResourceID();
        if (resourceID == null) {
            return;
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = resMgt.getImage(resourceID.toString());
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("\u56fe\u7247\u89e3\u6790\u5931\u8d25\uff01[resourceId: %s][%s]", resourceID.toString(), e.getMessage()));
            }
            logger.warn(String.format("\u56fe\u7247\u89e3\u6790\u5931\u8d25\uff01[resourceId: %s]", resourceID.toString()), (Throwable)e);
        }
        if (bufferedImage == null) {
            return;
        }
        contentStream.saveGraphicsState();
        CT_MultiMedia multiMedia = resMgt.getMultiMedia(resourceID.toString());
        PDImageXObject pdfImageObject = multiMedia != null && "JPEG".equals(multiMedia.getFormat()) ? JPEGFactory.createFromImage((PDDocument)this.pdf, (BufferedImage)bufferedImage) : LosslessFactory.createFromImage((PDDocument)this.pdf, (BufferedImage)bufferedImage);
        if (annotBox != null && !this.isSameBox(annotBox, imageObject.getBoundary())) {
            float x = annotBox.getTopLeftX().floatValue();
            float y = box.getHeight().floatValue() - (annotBox.getTopLeftY().floatValue() + annotBox.getHeight().floatValue());
            float width = annotBox.getWidth().floatValue();
            float height = annotBox.getHeight().floatValue();
            contentStream.drawImage(pdfImageObject, (float)CommonUtil.converterDpi(x), (float)CommonUtil.converterDpi(y), (float)CommonUtil.converterDpi(width), (float)CommonUtil.converterDpi(height));
        } else {
            Matrix matrix = CommonUtil.toPFMatrix(CommonUtil.getImageMatrixFromOfd(imageObject, box));
            contentStream.drawImage(pdfImageObject, matrix);
        }
        contentStream.restoreGraphicsState();
    }

    private void writeSealImage(PDPageContentStream contentStream, ST_Box box, byte[] image, ST_Box sealBox, ST_Box clipBox) throws IOException {
        if (image == null) {
            return;
        }
        contentStream.saveGraphicsState();
        PDImageXObject pdfImageObject = LosslessFactory.createFromImage((PDDocument)this.pdf, (BufferedImage)ImageIO.read(new ByteArrayInputStream(image)));
        float x = sealBox.getTopLeftX().floatValue();
        float y = box.getHeight().floatValue() - (sealBox.getTopLeftY().floatValue() + sealBox.getHeight().floatValue());
        float width = sealBox.getWidth().floatValue();
        float height = sealBox.getHeight().floatValue();
        if (clipBox != null) {
            contentStream.addRect((float)CommonUtil.converterDpi(x) + (float)CommonUtil.converterDpi(clipBox.getTopLeftX()), (float)CommonUtil.converterDpi(y) + (float)(CommonUtil.converterDpi(height) - (CommonUtil.converterDpi(clipBox.getTopLeftY()) + CommonUtil.converterDpi(clipBox.getHeight()))), (float)CommonUtil.converterDpi(clipBox.getWidth()), (float)CommonUtil.converterDpi(clipBox.getHeight()));
            contentStream.closePath();
            contentStream.clip();
            contentStream.stroke();
        }
        contentStream.drawImage(pdfImageObject, (float)CommonUtil.converterDpi(x), (float)CommonUtil.converterDpi(y), (float)CommonUtil.converterDpi(width), (float)CommonUtil.converterDpi(height));
        contentStream.restoreGraphicsState();
    }

    private float getTextObjectSize(TextObject textObject) {
        float fontSize = 0.353f;
        if (textObject == null) {
            return fontSize;
        }
        try {
            fontSize = textObject.getSize().floatValue();
        }
        catch (Exception e) {
            fontSize = 0.353f;
        }
        return fontSize;
    }

    private void writeText(ResourceManage resMgt, PDPageContentStream contentStream, ST_Box box, ST_Box sealBox, TextObject textObject, PDColor defaultFontColor, int alpha) throws IOException {
        double scale = this.scaling(sealBox, (CT_GraphicUnit)textObject);
        float fontSize = Double.valueOf(textObject.getSize() * scale).floatValue();
        if (sealBox != null && textObject.getBoundary() != null) {
            textObject.setBoundary(textObject.getBoundary().getTopLeftX() + sealBox.getTopLeftX(), textObject.getBoundary().getTopLeftY() + sealBox.getTopLeftY(), textObject.getBoundary().getWidth().doubleValue(), textObject.getBoundary().getHeight().doubleValue());
        }
        if (textObject.getCTM() != null) {
            Double[] ctm = textObject.getCTM().toDouble();
            double a = ctm[0];
            double b = ctm[1];
            double c = ctm[2];
            double d = ctm[3];
            double sx = a > 0.0 ? Math.signum(a) * Math.sqrt(a * a + c * c) : Math.sqrt(a * a + c * c);
            double sy = Math.signum(d) * Math.sqrt(b * b + d * d);
            double angel = Math.atan2(-b, d);
            if (angel != 0.0 || a == 0.0 || d != 1.0) {
                fontSize = (float)((double)fontSize * sx);
            }
        }
        PDColor fillColor = defaultFontColor;
        CT_DrawParam ctDrawParam = resMgt.superDrawParam((CT_GraphicUnit)textObject);
        if (ctDrawParam != null && textObject.getFillColor() == null && ctDrawParam.getFillColor() != null) {
            fillColor = CommonUtil.convertPDColor(ctDrawParam.getFillColor().getValue());
        }
        CT_Font ctFont = resMgt.getFont(textObject.getFont().toString());
        PDFont font = this.getFont(ctFont);
        List<TextCodePoint> textCodePointList = PointUtil.calPdfTextCoordinate(box.getWidth(), box.getHeight(), textObject.getBoundary(), fontSize, textObject.getTextCodes(), textObject.getCTM() != null, textObject.getCTM(), true, scale);
        double rx = 0.0;
        double ry = 0.0;
        for (int i = 0; i < textCodePointList.size(); ++i) {
            TextCodePoint textCodePoint = textCodePointList.get(i);
            if (i == 0) {
                rx = textCodePoint.x;
                ry = textCodePoint.y;
            }
            contentStream.saveGraphicsState();
            contentStream.beginText();
            contentStream.setNonStrokingColor(fillColor);
            contentStream.newLineAtOffset((float)textCodePoint.getX(), (float)textCodePoint.getY());
            if (textObject.getCTM() != null) {
                Double[] ctm = textObject.getCTM().toDouble();
                double a = ctm[0];
                double b = ctm[1];
                double c = ctm[2];
                double d = ctm[3];
                AffineTransform transform = new AffineTransform();
                double angel = Math.atan2(-b, d);
                transform.rotate(angel, rx, ry);
                contentStream.concatenate2CTM(transform);
                if (angel == 0.0 && a != 0.0 && d == 1.0) {
                    textObject.setHScale(Double.valueOf(a));
                }
            }
            if (textObject.getHScale().floatValue() < 1.0f) {
                AffineTransform transform = new AffineTransform();
                transform.setTransform(textObject.getHScale().floatValue(), 0.0, 0.0, 1.0, (double)(1.0f - textObject.getHScale().floatValue()) * textCodePoint.getX(), 0.0);
                contentStream.concatenate2CTM(transform);
            }
            contentStream.setFont(font, (float)CommonUtil.converterDpi(fontSize));
            try {
                contentStream.showText(textCodePoint.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            contentStream.endText();
            contentStream.restoreGraphicsState();
        }
    }

    public void addAttachments(OFDReader ofdReader) throws IOException {
        List attachmentList = ofdReader.getAttachmentList();
        if (attachmentList == null || attachmentList.isEmpty()) {
            return;
        }
        PDEmbeddedFilesNameTreeNode efTree = new PDEmbeddedFilesNameTreeNode();
        HashMap<String, PDComplexFileSpecification> efMap = new HashMap<String, PDComplexFileSpecification>();
        for (CT_Attachment attachment : attachmentList) {
            PDComplexFileSpecification fs = new PDComplexFileSpecification();
            Path attFile = ofdReader.getAttachmentFile(attachment);
            fs.setFile(attFile.getFileName().toString());
            PDEmbeddedFile ef = new PDEmbeddedFile(this.pdf, Files.newInputStream(attFile, new OpenOption[0]));
            ef.setSubtype(attachment.getFormat());
            ef.setSize((int)Files.size(attFile));
            LocalDateTime creationDate = attachment.getCreationDateTime();
            Date date = Date.from(creationDate.atZone(ZoneId.systemDefault()).toInstant());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            ef.setCreationDate(calendar);
            fs.setEmbeddedFile(ef);
            efMap.put(attachment.getAttachmentName(), fs);
        }
        efTree.setNames(efMap);
        PDDocumentNameDictionary names = new PDDocumentNameDictionary(this.pdf.getDocumentCatalog());
        names.setEmbeddedFiles(efTree);
        this.pdf.getDocumentCatalog().setNames(names);
    }

    private PDFont loadFont(CT_Font ctFont) throws IOException {
        boolean embedSubset = false;
        Path fontPath = null;
        if (ctFont != null && ctFont.getFontFile() != null) {
            try {
                ResourceLocator resourceLocator = this.reader.getResourceLocator();
                fontPath = resourceLocator.getFile(ctFont.getFontFile()).toAbsolutePath();
            }
            catch (Exception e) {
                logger.warn("\u65e0\u6cd5\u52a0\u8f7d\u5185\u5d4c\u5b57\u4f53: " + ctFont.getFamilyName() + " " + ctFont.getFontName() + " " + ctFont.getFontFile(), (Throwable)e);
            }
        }
        if (fontPath != null) {
            embedSubset = true;
        } else {
            String systemFontPath = FontLoader.getInstance().getReplaceSimilarFontPath(ctFont.getFamilyName(), ctFont.getFontName());
            if (systemFontPath != null) {
                fontPath = Paths.get(systemFontPath, new String[0]);
            }
        }
        if (fontPath == null) {
            fontPath = FontLoader.getInstance().getDefaultFontPath();
        }
        ByteArrayInputStream fontStream = new ByteArrayInputStream(Files.readAllBytes(fontPath));
        String name = fontPath.toFile().getName().toLowerCase();
        TrueTypeFont ttf = null;
        if (name.endsWith(".ttf")) {
            try {
                ttf = new TTFParser(embedSubset).parse((InputStream)fontStream);
            }
            catch (Exception ex) {
                ttf = new TTFParser(!embedSubset).parse((InputStream)fontStream);
            }
        } else if (name.endsWith(".otf")) {
            try {
                ttf = new OTFParser(embedSubset).parse((InputStream)fontStream);
            }
            catch (Exception ex) {
                ttf = new OTFParser(!embedSubset).parse((InputStream)fontStream);
            }
        } else if (name.endsWith(".ttc")) {
            TrueTypeCollection ttc = new TrueTypeCollection((InputStream)fontStream);
            if (ttc != null) {
                ttf = ttc.getFontByName(ctFont.getFontName());
                if (ttf == null) {
                    String alias = FontLoader.getInstance().getFontAlias(ctFont);
                    ttf = ttc.getFontByName(alias);
                }
                embedSubset = true;
                ttc.close();
            }
        } else {
            fontStream.close();
        }
        PDType0Font font = PDType0Font.load((PDDocument)this.pdf, (TrueTypeFont)ttf, (boolean)embedSubset);
        return font;
    }

    private PDFont getFont(CT_Font ctFont) {
        String key = String.format("%s_%s_%s", ctFont.getFamilyName(), ctFont.getFontName(), ctFont.getFontFile());
        if (this.fontCache.containsKey(key)) {
            return this.fontCache.get(key);
        }
        try {
            PDFont font = this.loadFont(ctFont);
            this.fontCache.put(key, font);
            return font;
        }
        catch (Exception e) {
            if (ctFont != null && ctFont.getFontFile() != null) {
                logger.info("\u65e0\u6cd5\u4f7f\u7528\u5b57\u4f53: {} {} {}", new Object[]{ctFont.getFamilyName(), ctFont.getFontName(), ctFont.getFontFile()});
            }
            return PDType1Font.HELVETICA_BOLD;
        }
    }
}

