/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.Collection;
import java.util.function.Predicate;
import org.noear.solon.Solon;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.Routing;

public interface Router {
    public void caseSensitive(boolean var1);

    public void addPathPrefix(String var1, Predicate<Class<?>> var2);

    public void add(String var1, MethodType var2, int var3, Handler var4);

    public void add(String var1, BeanWrap var2, boolean var3);

    public Result<Handler> matchMainAndStatus(Context var1);

    public Handler matchMain(Context var1);

    public Collection<Routing<Handler>> findAll();

    public Collection<Routing<Handler>> findBy(String var1);

    public Collection<Routing<Handler>> findBy(Class<?> var1);

    public void remove(String var1);

    public void remove(Class<?> var1);

    public void clear();

    public void filter(int var1, Filter var2);

    public void filterIfAbsent(int var1, Filter var2);

    default public void filter(Filter filter) {
        this.filter(0, filter);
    }

    public void routerInterceptor(int var1, RouterInterceptor var2);

    public void routerInterceptorIfAbsent(int var1, RouterInterceptor var2);

    default public void routerInterceptor(RouterInterceptor interceptor) {
        this.routerInterceptor(0, interceptor);
    }

    default public void add(String path, Handler handler) {
        this.add(path, MethodType.HTTP, handler);
    }

    default public void add(String path, MethodType method, Handler handler) {
        this.add(path, method, 0, handler);
    }

    default public void add(BeanWrap bw) {
        this.add(null, bw);
    }

    default public void add(String pathPrefix, BeanWrap bw) {
        this.add(pathPrefix, bw, bw.remoting());
    }

    default public void add(Class<?> clz) {
        BeanWrap bw = Solon.context().wrapAndPut(clz);
        this.add(null, bw);
    }

    default public void add(String pathPrefix, Class<?> clz) {
        BeanWrap bw = Solon.context().wrapAndPut(clz);
        this.add(pathPrefix, bw);
    }

    default public void add(String pathPrefix, Class<?> clz, boolean remoting) {
        BeanWrap bw = Solon.context().wrapAndPut(clz);
        this.add(pathPrefix, bw, remoting);
    }

    default public void all(String path, Handler handler) {
        this.add(path, MethodType.ALL, handler);
    }

    default public void http(String path, Handler handler) {
        this.add(path, MethodType.HTTP, handler);
    }

    default public void head(String path, Handler handler) {
        this.add(path, MethodType.HEAD, handler);
    }

    default public void get(String path, Handler handler) {
        this.add(path, MethodType.GET, handler);
    }

    default public void post(String path, Handler handler) {
        this.add(path, MethodType.POST, handler);
    }

    default public void put(String path, Handler handler) {
        this.add(path, MethodType.PUT, handler);
    }

    default public void patch(String path, Handler handler) {
        this.add(path, MethodType.PATCH, handler);
    }

    default public void delete(String path, Handler handler) {
        this.add(path, MethodType.DELETE, handler);
    }

    default public void socketd(String path, Handler handler) {
        this.add(path, MethodType.SOCKET, handler);
    }

    @Deprecated
    default public Collection<Routing<Handler>> getAll() {
        return this.findAll();
    }

    @Deprecated
    default public Collection<Routing<Handler>> getBy(String pathPrefix) {
        return this.findBy(pathPrefix);
    }

    @Deprecated
    default public Collection<Routing<Handler>> getBy(Class<?> controllerClz) {
        return this.findBy(controllerClz);
    }
}

