/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.config.yaml.PropertiesYaml;
import org.noear.solon.core.PropsLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropsLoaderExt
extends PropsLoader {
    static final Logger log = LoggerFactory.getLogger(PropsLoaderExt.class);

    public boolean isSupport(String suffix) {
        if (suffix == null) {
            return false;
        }
        return suffix.endsWith(".properties") || suffix.endsWith(".yml") || suffix.endsWith(".yaml");
    }

    public Properties load(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        String fileName = url.toString();
        if (fileName.endsWith(".properties")) {
            if (Solon.appIf(app -> app.cfg().isDebugMode())) {
                log.trace(fileName);
            }
            Properties tmp = new Properties();
            URLConnection urlConn = url.openConnection();
            try (InputStreamReader reader = new InputStreamReader(urlConn.getInputStream(), Solon.encoding());){
                tmp.load(reader);
            }
            if (urlConn instanceof JarURLConnection) {
                ((JarURLConnection)urlConn).getJarFile().close();
            }
            return tmp;
        }
        if (fileName.endsWith(".yml") || fileName.endsWith(".yaml")) {
            if (Solon.appIf(app -> app.cfg().isDebugMode())) {
                log.trace(fileName);
            }
            PropertiesYaml tmp = new PropertiesYaml();
            URLConnection urlConn = url.openConnection();
            try (InputStreamReader reader = new InputStreamReader(urlConn.getInputStream(), Solon.encoding());){
                tmp.loadYml(reader);
            }
            if (urlConn instanceof JarURLConnection) {
                ((JarURLConnection)urlConn).getJarFile().close();
            }
            return tmp;
        }
        throw new RuntimeException("This profile is not supported: " + fileName);
    }

    public Properties build(String text) throws IOException {
        if ((text = text.trim()).startsWith("{") && text.endsWith("}")) {
            PropertiesYaml tmp = new PropertiesYaml();
            tmp.loadYml(new StringReader(text));
            return tmp;
        }
        if (text.startsWith("[") && text.endsWith("]")) {
            PropertiesYaml tmp = new PropertiesYaml();
            tmp.loadYml(new StringReader(text));
            return tmp;
        }
        int idx1 = text.indexOf("=");
        int idx2 = text.indexOf(":");
        if (idx1 > 0 && (idx1 < idx2 || idx2 < 0)) {
            Properties tmp = new Properties();
            tmp.load(new StringReader(text));
            return tmp;
        }
        PropertiesYaml tmp = new PropertiesYaml();
        tmp.loadYml(new StringReader(text));
        return tmp;
    }
}

