/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server.resource;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import org.noear.eggg.MethodEggg;
import org.noear.solon.Utils;
import org.noear.solon.ai.annotation.ResourceMapping;
import org.noear.solon.ai.chat.tool.MethodExecuteHandler;
import org.noear.solon.ai.mcp.server.resource.FunctionResource;
import org.noear.solon.ai.media.Text;
import org.noear.solon.annotation.Produces;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.PathMatcher;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.core.wrap.MethodWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodFunctionResource
implements FunctionResource {
    static final Logger log = LoggerFactory.getLogger(MethodFunctionResource.class);
    private final BeanWrap beanWrap;
    private final MethodWrap methodWrap;
    private final String name;
    private final String title;
    private final ResourceMapping mapping;
    private final String mimeType;
    private PathMatcher pathKeysMatcher;
    private List<String> pathKeys;

    public MethodFunctionResource(BeanWrap beanWrap, MethodEggg methodEggg) {
        this.beanWrap = beanWrap;
        this.methodWrap = new MethodWrap(beanWrap.context(), beanWrap.clz(), methodEggg);
        this.mapping = methodEggg.getMethod().getAnnotation(ResourceMapping.class);
        this.name = Utils.annoAlias((String)this.mapping.name(), (String)methodEggg.getName());
        Assert.notNull((Object)this.mapping, (String)"@ResourceMapping annotation is missing");
        Assert.notEmpty((String)this.mapping.description(), (String)"ResourceMapping description cannot be empty");
        this.title = this.mapping.title();
        Produces producesAnno = methodEggg.getMethod().getAnnotation(Produces.class);
        this.mimeType = producesAnno != null ? producesAnno.value() : this.mapping.mimeType();
        if (this.mapping.uri() != null && this.mapping.uri().indexOf(123) >= 0) {
            this.pathKeys = new ArrayList<String>();
            Matcher pm = PathUtil.pathKeyExpr.matcher(this.mapping.uri());
            while (pm.find()) {
                this.pathKeys.add(pm.group(1));
            }
            if (this.pathKeys.size() > 0) {
                this.pathKeysMatcher = PathMatcher.get((String)this.mapping.uri(), (boolean)false);
            }
        }
    }

    @Override
    public String uri() {
        return this.mapping.uri();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.mapping.description();
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public Text handle(String reqUri) throws Throwable {
        try {
            return this.doHandle(reqUri);
        }
        catch (Throwable ex) {
            if (log.isWarnEnabled()) {
                log.warn("Resource handle error, name: '{}'", (Object)this.name, (Object)ex);
            }
            throw ex;
        }
    }

    private Text doHandle(String reqUri) throws Throwable {
        Context ctx = Context.current();
        if (ctx == null) {
            ctx = new ContextEmpty();
        }
        this.bindPathVarDo(ctx, reqUri);
        ctx.result = MethodExecuteHandler.getInstance().executeHandle(ctx, this.beanWrap.get(), this.methodWrap);
        if (ctx.result instanceof Text) {
            return (Text)ctx.result;
        }
        if (ctx.result instanceof byte[]) {
            String blob = Base64.getEncoder().encodeToString((byte[])ctx.result);
            return Text.of((boolean)true, (String)blob);
        }
        String text = String.valueOf(ctx.result);
        return Text.of((boolean)false, (String)text);
    }

    private void bindPathVarDo(Context c, String reqUri) throws Throwable {
        Matcher pm;
        if (this.pathKeysMatcher != null && (pm = this.pathKeysMatcher.matcher(reqUri)).find()) {
            int len = this.pathKeys.size();
            for (int i = 0; i < len; ++i) {
                c.paramMap().add(this.pathKeys.get(i), (Object)pm.group(i + 1));
            }
        }
    }
}

