/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.reranking;

import java.util.Collections;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.reranking.Reranking;
import org.noear.solon.ai.reranking.RerankingException;
import org.noear.solon.lang.Nullable;

public class RerankingResponse {
    private final String model;
    private final RerankingException error;
    private final List<Reranking> results;
    private final AiUsage usage;

    public RerankingResponse(String model, RerankingException error, List<Reranking> results, AiUsage usage) {
        this.model = model;
        this.error = error;
        this.results = results;
        this.usage = usage;
        if (results != null) {
            Collections.sort(this.results);
        }
    }

    public String getModel() {
        return this.model;
    }

    public @Nullable RerankingException getError() {
        return this.error;
    }

    public boolean hasResults() {
        return Utils.isNotEmpty(this.results);
    }

    public @Nullable List<Reranking> getResults() {
        return this.results;
    }

    public AiUsage getUsage() {
        return this.usage;
    }

    public String toString() {
        return "{model='" + this.model + '\'' + ", results=" + this.results + ", usage=" + this.usage + '}';
    }
}

