/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.splitter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.rag.DocumentSplitter;

public class JsonSplitter
implements DocumentSplitter {
    private List<String> contentSelector;
    private Function<Map<String, Object>, Map<String, Object>> metadataMapper;

    public JsonSplitter contentSelector(String ... keys) {
        this.contentSelector = Arrays.asList(keys);
        return this;
    }

    public JsonSplitter metadataMapper(Function<Map<String, Object>, Map<String, Object>> mapper) {
        this.metadataMapper = mapper;
        return this;
    }

    @Override
    public List<Document> split(List<Document> documents) {
        ArrayList<Document> outs = new ArrayList<Document>();
        for (Document doc : documents) {
            this.splitDocument(doc, outs);
        }
        return outs;
    }

    protected List<Document> splitDocument(Document in, List<Document> outs) {
        for (Document doc : this.splitJson(in.getContent())) {
            in.getMetadata().forEach((k, v) -> doc.getMetadata().putIfAbsent((String)k, v));
            outs.add(doc);
        }
        return outs;
    }

    protected List<Document> splitJson(String josn) {
        ArrayList<Document> tmp = new ArrayList<Document>();
        ONode oNode = ONode.ofJson((String)josn, (Feature[])new Feature[0]);
        if (oNode.isArray()) {
            for (ONode n1 : oNode.getArrayUnsafe()) {
                this.splitJsonNode(n1, tmp);
            }
        } else {
            this.splitJsonNode(oNode, tmp);
        }
        return tmp;
    }

    protected void splitJsonNode(ONode oNode, List<Document> docs) {
        if (oNode.isArray()) {
            for (ONode n1 : oNode.getArrayUnsafe()) {
                this.splitJsonNode(n1, docs);
            }
        } else if (oNode.isObject()) {
            Map jsonData = (Map)oNode.toBean(Map.class);
            docs.add(new Document(this.buildContent(jsonData), this.buildMetadata(jsonData)));
        }
    }

    protected String buildContent(Map<String, Object> jsonData) {
        StringBuilder buf = new StringBuilder();
        if (Utils.isEmpty(this.contentSelector)) {
            for (Map.Entry<String, Object> kv : jsonData.entrySet()) {
                buf.append(kv.getKey()).append(": ").append(kv.getValue()).append("\n");
            }
        } else {
            for (String key : this.contentSelector) {
                buf.append(key).append(": ").append(jsonData.get(key)).append("\n");
            }
        }
        return buf.toString();
    }

    protected Map<String, Object> buildMetadata(Map<String, Object> jsonData) {
        Map<String, Object> metadata = null;
        if (this.metadataMapper != null) {
            metadata = this.metadataMapper.apply(jsonData);
        }
        return metadata;
    }
}

