/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.solon.ai.AiConfig;
import org.noear.solon.ai.embedding.EmbeddingModel;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.rag.Repository;
import org.noear.solon.ai.rag.util.QueryCondition;
import org.noear.solon.ai.rag.util.SimilarityUtil;
import org.noear.solon.lang.Nullable;
import org.noear.solon.net.http.HttpUtils;

public class WebSearchRepository
implements Repository {
    private final AiConfig config;
    private final @Nullable EmbeddingModel embeddingModel;

    public WebSearchRepository(AiConfig config) {
        this(null, config);
    }

    public WebSearchRepository(EmbeddingModel embeddingModel, AiConfig config) {
        this.embeddingModel = embeddingModel;
        this.config = config;
    }

    @Override
    public List<Document> search(QueryCondition condition) throws IOException {
        HttpUtils httpUtils = this.config.createHttpUtils();
        ONode reqNode = new ONode();
        reqNode.set("query", (Object)condition.getQuery());
        reqNode.set("count", (Object)String.valueOf(condition.getLimit()));
        if (condition.getFreshness() != null) {
            reqNode.set("freshness", (Object)condition.getFreshness().value);
        }
        String respJson = httpUtils.bodyOfJson(reqNode.toJson()).post();
        ONode respNode = ONode.ofJson((String)respJson, (Feature[])new Feature[0]);
        int code = respNode.get("code").getInt();
        String msg = respNode.get("msg").getString();
        if (code != 200) {
            throw new IOException(msg);
        }
        ArrayList<Document> docs = new ArrayList<Document>();
        for (ONode n1 : respNode.get("data").get("webPages").get("value").getArray()) {
            docs.add(new Document(n1.get("snippet").getString()).title(n1.get("title").getString()).url(n1.get("url").getString()));
        }
        if (this.embeddingModel != null) {
            this.embeddingModel.embed(docs);
            float[] queryEmbed = this.embeddingModel.embed(condition.getQuery());
            return SimilarityUtil.refilter(docs.stream().map(doc -> SimilarityUtil.score(doc, queryEmbed)), condition);
        }
        return docs;
    }

    public static Builder of(String apiUrl) {
        return new Builder(apiUrl);
    }

    public static class Builder {
        private AiConfig config = new AiConfig();
        private EmbeddingModel embeddingModel;

        public Builder(String apiUrl) {
            this.config.setApiUrl(apiUrl);
        }

        public Builder apiKey(String apiKey) {
            this.config.setApiKey(apiKey);
            return this;
        }

        public Builder embeddingModel(EmbeddingModel embeddingModel) {
            this.embeddingModel = embeddingModel;
            return this;
        }

        public WebSearchRepository build() {
            return new WebSearchRepository(this.embeddingModel, this.config);
        }
    }
}

