/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.media;

import java.util.Base64;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.media.AbstractMedia;

public class Video
extends AbstractMedia<Video>
implements AiMedia {
    @Override
    public String getMimeType() {
        if (Utils.isEmpty((String)this.mimeType)) {
            return "video/mpeg";
        }
        return this.mimeType;
    }

    public static Video ofUrl(String url) {
        Video tmp = new Video();
        tmp.url = url;
        return tmp;
    }

    public static Video ofBase64(String base64String) {
        Video tmp = new Video();
        tmp.b64_json = base64String;
        return tmp;
    }

    public static Video ofBase64(String base64String, String mimeType) {
        Video tmp = new Video();
        tmp.b64_json = base64String;
        tmp.mimeType = mimeType;
        return tmp;
    }

    public static Video ofBase64(byte[] base64, String mimeType) {
        Video tmp = new Video();
        tmp.b64_json = Base64.getEncoder().encodeToString(base64);
        tmp.mimeType = mimeType;
        return tmp;
    }

    public static Video ofBase64(byte[] base64) {
        Video tmp = new Video();
        tmp.b64_json = Base64.getEncoder().encodeToString(base64);
        return tmp;
    }
}

