/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.media;

import java.util.Base64;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.media.AbstractMedia;

public class Audio
extends AbstractMedia<Audio>
implements AiMedia {
    @Override
    public String getMimeType() {
        if (Utils.isEmpty((String)this.mimeType)) {
            return "audio/mpeg";
        }
        return this.mimeType;
    }

    public static Audio ofUrl(String url) {
        Audio tmp = new Audio();
        tmp.url = url;
        return tmp;
    }

    public static Audio ofBase64(String base64String) {
        Audio tmp = new Audio();
        tmp.b64_json = base64String;
        return tmp;
    }

    public static Audio ofBase64(String base64String, String mimeType) {
        Audio tmp = new Audio();
        tmp.b64_json = base64String;
        tmp.mimeType = mimeType;
        return tmp;
    }

    public static Audio ofBase64(byte[] base64, String mimeType) {
        Audio tmp = new Audio();
        tmp.b64_json = Base64.getEncoder().encodeToString(base64);
        tmp.mimeType = mimeType;
        return tmp;
    }

    public static Audio ofBase64(byte[] base64) {
        Audio tmp = new Audio();
        tmp.b64_json = Base64.getEncoder().encodeToString(base64);
        return tmp;
    }
}

