/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.media;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;

public abstract class AbstractMedia<T extends AbstractMedia>
implements AiMedia {
    protected String b64_json;
    protected String url;
    protected String mimeType;
    protected Map<String, Object> metadata;

    @Override
    public Map<String, Object> metas() {
        if (this.metadata == null) {
            this.metadata = new LinkedHashMap<String, Object>();
        }
        return this.metadata;
    }

    public T metaAdd(String key, Object value) {
        this.metas().put(key, value);
        return (T)this;
    }

    public String getB64Json() {
        return this.b64_json;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String toDataString(boolean useMime) {
        if (Utils.isEmpty((String)this.getB64Json())) {
            return this.getUrl();
        }
        if (useMime && Utils.isNotEmpty((String)this.getMimeType())) {
            return "data:" + this.getMimeType() + ";base64," + this.getB64Json();
        }
        return this.getB64Json();
    }

    @Override
    public Map<String, Object> toData(boolean useMime) {
        if (Utils.isEmpty((String)this.getB64Json())) {
            return Utils.asMap((Object[])new Object[]{"url", this.getUrl()});
        }
        if (useMime && Utils.isNotEmpty((String)this.getMimeType())) {
            return Utils.asMap((Object[])new Object[]{"mimeType", this.getMimeType(), "data", this.getB64Json()});
        }
        return Utils.asMap((Object[])new Object[]{"data", this.getB64Json()});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{url='" + this.getUrl() + '\'' + ", b64_json='" + this.getB64Json() + '\'' + ", mimeType='" + this.getMimeType() + '\'' + '}';
    }
}

