/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.image;

import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.image.ImageException;
import org.noear.solon.ai.media.Image;
import org.noear.solon.lang.Nullable;

public class ImageResponse {
    private final String model;
    private final ImageException error;
    private final List<Image> data;
    private final AiUsage usage;

    public ImageResponse(String model, ImageException error, List<Image> data, AiUsage usage) {
        this.model = model;
        this.error = error;
        this.data = data;
        this.usage = usage;
    }

    public String getModel() {
        return this.model;
    }

    public @Nullable ImageException getError() {
        return this.error;
    }

    public boolean hasData() {
        return Utils.isNotEmpty(this.data);
    }

    public @Nullable List<Image> getData() {
        return this.data;
    }

    public @Nullable Image getImage() {
        if (this.hasData()) {
            return this.data.get(0);
        }
        return null;
    }

    public AiUsage getUsage() {
        return this.usage;
    }

    public String toString() {
        return "{model='" + this.model + '\'' + ", data=" + this.data + ", usage=" + this.usage + '}';
    }
}

