/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.image;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.Properties;
import org.noear.solon.ai.AiModel;
import org.noear.solon.ai.image.ImageConfig;
import org.noear.solon.ai.image.ImagePrompt;
import org.noear.solon.ai.image.ImageRequestDesc;
import org.noear.solon.ai.image.dialect.ImageDialect;
import org.noear.solon.ai.image.dialect.ImageDialectManager;
import org.noear.solon.core.Props;
import org.noear.solon.core.util.Assert;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class ImageModel
implements AiModel {
    private final ImageConfig config;
    private final ImageDialect dialect;

    public ImageModel(Properties properties) {
        this((ImageConfig)Props.from((Properties)properties).bindTo((Object)new ImageConfig()));
    }

    public ImageModel(ImageConfig config) {
        Assert.notNull((Object)config, (String)"The config is required");
        Assert.notNull((Object)config.getApiUrl(), (String)"The config.apiUrl is required");
        Assert.notNull((Object)config.getModel(), (String)"The config.model is required");
        this.dialect = ImageDialectManager.select(config);
        this.config = config;
    }

    public ImageRequestDesc prompt(String prompt) {
        return new ImageRequestDesc(this.config, this.dialect, prompt, null);
    }

    public ImageRequestDesc prompt(ImagePrompt prompt) {
        return new ImageRequestDesc(this.config, this.dialect, null, prompt.toMap());
    }

    public String toString() {
        return "ImageModel{config=" + this.config + ", dialect=" + this.dialect.getClass().getName() + '}';
    }

    public static Builder of(ImageConfig config) {
        return new Builder(config);
    }

    public static Builder of(String apiUrl) {
        return new Builder(apiUrl);
    }

    public static class Builder {
        private final ImageConfig config;

        public Builder(String apiUrl) {
            this.config = new ImageConfig();
            this.config.setApiUrl(apiUrl);
        }

        public Builder(ImageConfig config) {
            this.config = config;
        }

        public Builder apiKey(String apiKey) {
            this.config.setApiKey(apiKey);
            return this;
        }

        public Builder provider(String provider) {
            this.config.setProvider(provider);
            return this;
        }

        public Builder model(String model) {
            this.config.setModel(model);
            return this;
        }

        public Builder headerSet(String key, String value) {
            this.config.setHeader(key, value);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.config.setTimeout(timeout);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.config.setProxy(proxy);
            return this;
        }

        public Builder proxy(String host, int port) {
            return this.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)));
        }

        public ImageModel build() {
            return new ImageModel(this.config);
        }
    }
}

