/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.generate;

import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.generate.GenerateContent;
import org.noear.solon.ai.generate.GenerateException;
import org.noear.solon.lang.Nullable;
import org.noear.solon.lang.Preview;

@Preview(value="3.5")
public class GenerateResponse {
    private final String model;
    private final GenerateException error;
    private final List<GenerateContent> data;
    private final AiUsage usage;

    public GenerateResponse(String model, GenerateException error, List<GenerateContent> data, AiUsage usage) {
        this.model = model;
        this.error = error;
        this.data = data;
        this.usage = usage;
    }

    public String getModel() {
        return this.model;
    }

    public @Nullable GenerateException getError() {
        return this.error;
    }

    public boolean hasData() {
        return Utils.isNotEmpty(this.data);
    }

    public @Nullable List<GenerateContent> getData() {
        return this.data;
    }

    public @Nullable GenerateContent getContent() {
        if (this.hasData()) {
            return this.data.get(0);
        }
        return null;
    }

    public AiUsage getUsage() {
        return this.usage;
    }

    public String toString() {
        return "{model='" + this.model + '\'' + ", data=" + this.data + ", usage=" + this.usage + '}';
    }
}

