/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.generate;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.noear.solon.Utils;
import org.noear.solon.ai.generate.GenerateConfig;
import org.noear.solon.ai.generate.GenerateOptions;
import org.noear.solon.ai.generate.GenerateResponse;
import org.noear.solon.ai.generate.dialect.GenerateDialect;
import org.noear.solon.lang.Preview;
import org.noear.solon.net.http.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Preview(value="3.5")
public class GenerateRequestDesc {
    private static final Logger log = LoggerFactory.getLogger(GenerateRequestDesc.class);
    private final GenerateConfig config;
    private final GenerateDialect dialect;
    private final String promptStr;
    private final Map promptMap;
    private GenerateOptions options;

    protected GenerateRequestDesc(GenerateConfig config, GenerateDialect dialect, String promptStr, Map promptMap) {
        this.config = config;
        this.dialect = dialect;
        this.promptStr = promptStr;
        this.promptMap = promptMap;
        this.options = new GenerateOptions();
        if (Utils.isNotEmpty(config.getDefaultOptions())) {
            this.options.options().putAll(config.getDefaultOptions());
        }
    }

    public GenerateRequestDesc options(GenerateOptions options) {
        if (options != null) {
            this.options = options;
        }
        return this;
    }

    public GenerateRequestDesc options(Consumer<GenerateOptions> optionsBuilder) {
        optionsBuilder.accept(this.options);
        return this;
    }

    public GenerateResponse call() throws IOException {
        GenerateResponse resp;
        HttpUtils httpUtils = this.config.createHttpUtils();
        String reqJson = this.dialect.buildRequestJson(this.config, this.options, this.promptStr, this.promptMap);
        if (log.isDebugEnabled()) {
            log.debug("ai-request: {}", (Object)reqJson);
        }
        String respJson = httpUtils.bodyOfJson(reqJson).post();
        if (log.isDebugEnabled()) {
            log.debug("ai-response: {}", (Object)respJson);
        }
        if ((resp = this.dialect.parseResponseJson(this.config, respJson)).getError() != null) {
            throw resp.getError();
        }
        return resp;
    }
}

