/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.generate;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.noear.solon.ai.AiModel;
import org.noear.solon.ai.generate.GenerateConfig;
import org.noear.solon.ai.generate.GeneratePrompt;
import org.noear.solon.ai.generate.GenerateRequestDesc;
import org.noear.solon.ai.generate.dialect.GenerateDialect;
import org.noear.solon.ai.generate.dialect.GenerateDialectManager;
import org.noear.solon.core.Props;
import org.noear.solon.core.util.Assert;
import org.noear.solon.lang.Preview;

@Preview(value="3.5")
public class GenerateModel
implements AiModel {
    private final GenerateConfig config;
    private final GenerateDialect dialect;

    public GenerateModel(Properties properties) {
        this((GenerateConfig)Props.from((Properties)properties).bindTo((Object)new GenerateConfig()));
    }

    public GenerateModel(GenerateConfig config) {
        Assert.notNull((Object)config, (String)"The config is required");
        Assert.notNull((Object)config.getApiUrl(), (String)"The config.apiUrl is required");
        Assert.notNull((Object)config.getModel(), (String)"The config.model is required");
        this.dialect = GenerateDialectManager.select(config);
        this.config = config;
    }

    public GenerateRequestDesc prompt(String prompt) {
        return new GenerateRequestDesc(this.config, this.dialect, prompt, null);
    }

    public GenerateRequestDesc prompt(GeneratePrompt prompt) {
        return new GenerateRequestDesc(this.config, this.dialect, null, prompt.toMap());
    }

    public GenerateRequestDesc prompt(Map<String, Object> prompt) {
        return new GenerateRequestDesc(this.config, this.dialect, null, prompt);
    }

    public String toString() {
        return "GenerateModel{config=" + this.config + ", dialect=" + this.dialect.getClass().getName() + '}';
    }

    public static Builder of(GenerateConfig config) {
        return new Builder(config);
    }

    public static Builder of(String apiUrl) {
        return new Builder(apiUrl);
    }

    public static class Builder {
        private final GenerateConfig config;

        public Builder(String apiUrl) {
            this.config = new GenerateConfig();
            this.config.setApiUrl(apiUrl);
        }

        public Builder(GenerateConfig config) {
            this.config = config;
        }

        public Builder taskUrl(String taskUrl) {
            this.config.setTaskUrl(taskUrl);
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.config.setApiKey(apiKey);
            return this;
        }

        public Builder provider(String provider) {
            this.config.setProvider(provider);
            return this;
        }

        public Builder model(String model) {
            this.config.setModel(model);
            return this;
        }

        public Builder headerSet(String key, String value) {
            this.config.setHeader(key, value);
            return this;
        }

        public Builder defaultOptionAdd(String key, Object val) {
            this.config.addDefaultOption(key, val);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.config.setTimeout(timeout);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.config.setProxy(proxy);
            return this;
        }

        public Builder proxy(String host, int port) {
            return this.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)));
        }

        public GenerateModel build() {
            return new GenerateModel(this.config);
        }
    }
}

