/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.tool;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.noear.eggg.FieldEggg;
import org.noear.eggg.TypeEggg;
import org.noear.snack4.ONode;
import org.noear.snack4.annotation.ONodeAttrHolder;
import org.noear.snack4.codec.util.EgggDigestAddin;
import org.noear.snack4.codec.util.EgggUtil;
import org.noear.snack4.jsonschema.JsonSchema;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.tool.impl.BodyAnnoDetector;
import org.noear.solon.ai.chat.tool.impl.ParamAnnoResolver;
import org.noear.solon.ai.util.ParamDesc;
import org.noear.solon.annotation.Param;
import org.noear.solon.lang.Nullable;

public class ToolSchemaUtil {
    private static List<Predicate<AnnotatedElement>> bodyDetectors = new CopyOnWriteArrayList<Predicate<AnnotatedElement>>();
    private static List<BiFunction<AnnotatedElement, TypeEggg, ParamDesc>> paramResolvers = new CopyOnWriteArrayList<BiFunction<AnnotatedElement, TypeEggg, ParamDesc>>();
    private static JsonSchema jsonSchema = JsonSchema.builder().build();

    public static void addBodyDetector(Predicate<AnnotatedElement> detector) {
        bodyDetectors.add(detector);
    }

    public static void addParamResolver(BiFunction<AnnotatedElement, TypeEggg, ParamDesc> resolver) {
        paramResolvers.add(resolver);
    }

    public static void addNodeDescribe(Class<? extends Annotation> annoType, EgggDigestAddin digestAddin) {
        EgggUtil.addDigestAddin(annoType, (EgggDigestAddin)digestAddin);
    }

    private static boolean hasBodyAnno(AnnotatedElement element) {
        for (Predicate<AnnotatedElement> d1 : bodyDetectors) {
            if (!d1.test(element)) continue;
            return true;
        }
        return false;
    }

    private static @Nullable ParamDesc getParamDesc(AnnotatedElement element, TypeEggg typeEggg) {
        for (BiFunction<AnnotatedElement, TypeEggg, ParamDesc> r1 : paramResolvers) {
            ParamDesc pd = r1.apply(element, typeEggg);
            if (pd == null) continue;
            return pd;
        }
        return null;
    }

    @Deprecated
    public static @Nullable ParamDesc paramOf(AnnotatedElement ae, TypeEggg typeEggg) {
        return ToolSchemaUtil.getParamDesc(ae, typeEggg);
    }

    public static @Nullable Map<String, ParamDesc> buildInputParams(AnnotatedElement ae, TypeEggg typeEggg) {
        ParamDesc pd1 = ToolSchemaUtil.getParamDesc(ae, typeEggg);
        if (pd1 != null) {
            return Collections.singletonMap(pd1.name(), pd1);
        }
        LinkedHashMap<String, ParamDesc> paramMap = new LinkedHashMap<String, ParamDesc>();
        if (ToolSchemaUtil.hasBodyAnno(ae)) {
            for (FieldEggg fg1 : typeEggg.getClassEggg().getAllFieldEgggs()) {
                pd1 = ToolSchemaUtil.getParamDesc(fg1.getField(), fg1.getTypeEggg());
                if (pd1 == null) {
                    pd1 = new ParamDesc(fg1.getName(), fg1.getGenericType(), false, "");
                }
                paramMap.put(pd1.name(), pd1);
            }
        }
        return paramMap;
    }

    public static String buildInputSchema(Collection<ParamDesc> paramAry) {
        ONode rootNode = new ONode();
        ONode requiredNode = new ONode().asArray();
        rootNode.set("type", (Object)"object");
        rootNode.getOrNew("properties").then(propertiesNode -> {
            propertiesNode.asObject(TreeMap::new);
            for (ParamDesc fp : paramAry) {
                ONode paramNode = ToolSchemaUtil.createSchema(fp.type());
                paramNode.set("description", (Object)fp.description());
                propertiesNode.set(fp.name(), (Object)paramNode);
                if (!fp.required()) continue;
                requiredNode.add((Object)fp.name());
            }
        });
        if (requiredNode.getArrayUnsafe().size() > 0) {
            rootNode.set("required", (Object)requiredNode);
        }
        return rootNode.toJson();
    }

    public static String buildOutputSchema(Type returnType) {
        return ToolSchemaUtil.createSchema(returnType).toJson();
    }

    public static ONode createSchema(Type type) {
        return jsonSchema.createGenerator(type).generate();
    }

    public static boolean isIgnoreOutputSchema(Type type) {
        if (type == Void.TYPE) {
            return true;
        }
        if (type == String.class) {
            return true;
        }
        if (type == Boolean.class) {
            return true;
        }
        if (type instanceof Class) {
            Class clz = (Class)type;
            if (Number.class.isAssignableFrom(clz)) {
                return true;
            }
            if (Date.class.isAssignableFrom(clz)) {
                return true;
            }
            return clz.isPrimitive() || clz.isEnum();
        }
        return false;
    }

    static {
        EgggUtil.addDigestAddin(Param.class, (ce, ae, anno) -> {
            String name = Utils.annoAlias((String)anno.value(), (String)anno.value());
            if (Utils.isEmpty((String)name)) {
                if (ae instanceof FieldEggg) {
                    name = ((FieldEggg)ae).getName();
                } else {
                    return null;
                }
            }
            return new ONodeAttrHolder(name, null, anno.description(), anno.required());
        });
        bodyDetectors.add(new BodyAnnoDetector());
        paramResolvers.add(new ParamAnnoResolver());
    }
}

