/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.tool;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.solon.core.handle.AbstractEntityReader;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.LazyReference;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;

public class MethodExecuteHandler
extends AbstractEntityReader {
    private static MethodExecuteHandler instance = new MethodExecuteHandler();
    public static final String MCP_BODY_ATTR = "MCP_BODY";

    public static MethodExecuteHandler getInstance() {
        return instance;
    }

    public Object executeHandle(Context ctx, Object target, MethodWrap mWrap) throws Throwable {
        Object[] args = this.doRead(ctx, target, mWrap);
        return mWrap.invokeByAspect(target, args);
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) {
        return ONode.ofBean((Object)ctx.attr(MCP_BODY_ATTR), (Feature[])new Feature[0]);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, LazyReference bodyRef) throws Throwable {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.spec().getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        Object bodyObj = bodyRef.get();
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        ONode tmp = (ONode)bodyObj;
        if (tmp.isObject()) {
            if (!p.spec().isRequiredBody() && tmp.hasKey(p.spec().getName())) {
                if (p.spec().isGenericType()) {
                    return tmp.get(p.spec().getName()).toBean((Type)p.getGenericType());
                }
                return tmp.get(p.spec().getName()).toBean(pt);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyRef);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.toBean((Type)p.getGenericType());
            }
            return tmp.toBean(pt);
        }
        if (tmp.isArray()) {
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.toBean((Type)p.getGenericType());
            }
            return tmp.toBean(pt);
        }
        return tmp.getValue();
    }
}

