/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.ChatSession;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.chat.message.SystemMessage;
import org.noear.solon.ai.chat.message.ToolMessage;
import org.noear.solon.ai.chat.tool.ToolCall;
import org.noear.solon.lang.Preview;

@Preview(value="3.4")
public class InMemoryChatSession
implements ChatSession {
    protected final String sessionId;
    protected final List<ChatMessage> messages = new ArrayList<ChatMessage>();
    protected final int maxMessages;

    protected InMemoryChatSession(String sessionId, List<SystemMessage> systemMessages, List<ChatMessage> messages, int maxMessages) {
        this.sessionId = sessionId == null ? Utils.guid() : sessionId;
        if (systemMessages != null) {
            this.messages.addAll(systemMessages);
        }
        if (messages != null) {
            this.messages.addAll(messages);
        }
        this.maxMessages = maxMessages;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    @Override
    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    @Override
    public void addMessage(Collection<? extends ChatMessage> messages) {
        if (Utils.isNotEmpty(messages)) {
            this.messages.addAll(messages);
            if (this.maxMessages > 0 && this.messages.size() > this.maxMessages) {
                this.removeNonSystemMessages(messages.size());
            }
        }
    }

    private void removeNonSystemMessages(int size) {
        Iterator<ChatMessage> iterator = this.messages.iterator();
        int removeNums = 0;
        while (iterator.hasNext() && removeNums < size) {
            List<ToolCall> toolCalls;
            ChatMessage message = iterator.next();
            if (message instanceof SystemMessage) continue;
            iterator.remove();
            ++removeNums;
            if (!(message instanceof AssistantMessage) || !Utils.isNotEmpty(toolCalls = ((AssistantMessage)message).getToolCalls())) continue;
            while (iterator.hasNext() && iterator.next() instanceof ToolMessage) {
                iterator.remove();
                ++removeNums;
            }
        }
    }

    @Override
    public void clear() {
        this.messages.clear();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sessionId;
        private List<ChatMessage> messages;
        private List<SystemMessage> systemMessages;
        private int maxMessages;

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder systemMessages(SystemMessage ... systemMessages) {
            this.systemMessages = Arrays.asList(systemMessages);
            return this;
        }

        public Builder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder maxMessages(int maxMessages) {
            this.maxMessages = maxMessages;
            return this;
        }

        public InMemoryChatSession build() {
            return new InMemoryChatSession(this.sessionId, this.systemMessages, this.messages, this.maxMessages);
        }
    }
}

