/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.message;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.chat.ChatRole;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.message.SystemMessage;
import org.noear.solon.ai.chat.message.SystemMessageTemplate;
import org.noear.solon.ai.chat.message.ToolMessage;
import org.noear.solon.ai.chat.message.UserMessage;
import org.noear.solon.ai.chat.message.UserMessageTemplate;

public interface ChatMessage
extends Serializable {
    public ChatRole getRole();

    public String getContent();

    public Map<String, Object> getMetadata();

    public ChatMessage addMetadata(Map<String, Object> var1);

    public ChatMessage addMetadata(String var1, Object var2);

    default public boolean isThinking() {
        return false;
    }

    public static AssistantMessage ofAssistant(String content) {
        return new AssistantMessage(content);
    }

    public static SystemMessage ofSystem(String content) {
        return new SystemMessage(content);
    }

    public static UserMessage ofUser(String content) {
        return new UserMessage(content, null);
    }

    public static UserMessage ofUser(String content, List<AiMedia> medias) {
        return new UserMessage(content, medias);
    }

    public static UserMessage ofUser(String content, AiMedia ... medias) {
        return new UserMessage(content, Arrays.asList(medias));
    }

    public static UserMessage ofUser(AiMedia media) {
        return new UserMessage("", Arrays.asList(media));
    }

    public static ToolMessage ofTool(String content, String name, String toolCallId) {
        return ChatMessage.ofTool(content, name, toolCallId, false);
    }

    public static ToolMessage ofTool(String content, String name, String toolCallId, boolean returnDirect) {
        return new ToolMessage(content, name, toolCallId, returnDirect);
    }

    public static UserMessage ofUserAugment(String message, Object context) {
        String newContent = String.format("%s\n\n Now: %s\n\n References: %s", message, LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME), context);
        return new UserMessage(newContent);
    }

    public static SystemMessageTemplate ofSystemTmpl(String tmpl) {
        return new SystemMessageTemplate(tmpl);
    }

    public static UserMessageTemplate ofUserTmpl(String tmpl) {
        return new UserMessageTemplate(tmpl);
    }

    @Deprecated
    public static UserMessageTemplate template(String tmpl) {
        return ChatMessage.ofUserTmpl(tmpl);
    }

    @Deprecated
    public static ChatMessage augment(String message, Object context) {
        return ChatMessage.ofUserAugment(message, context);
    }

    public static String toJson(ChatMessage message) {
        return ONode.ofBean((Object)message, (Feature[])new Feature[]{Feature.Write_EnumUsingName}).toJson();
    }

    public static ChatMessage fromJson(String json) {
        ONode oNode = ONode.ofJson((String)json, (Feature[])new Feature[0]);
        ChatRole role = ChatRole.valueOf(oNode.get("role").getString());
        if (role == ChatRole.TOOL) {
            return (ChatMessage)oNode.toBean(ToolMessage.class);
        }
        if (role == ChatRole.SYSTEM) {
            return (ChatMessage)oNode.toBean(SystemMessage.class);
        }
        if (role == ChatRole.USER) {
            return (ChatMessage)oNode.toBean(UserMessage.class);
        }
        return (ChatMessage)oNode.toBean(AssistantMessage.class);
    }
}

