/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.chat.ChatChoice;
import org.noear.solon.ai.chat.ChatException;
import org.noear.solon.ai.chat.ChatResponse;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.tool.ToolCallBuilder;
import org.noear.solon.lang.Nullable;

public class ChatResponseDefault
implements ChatResponse {
    private final boolean stream;
    protected String responseData;
    protected final List<ChatChoice> choices = new ArrayList<ChatChoice>();
    protected ChatException error;
    protected AiUsage usage;
    protected String model;
    protected boolean finished;
    protected final Map<Integer, ToolCallBuilder> toolCallBuilders = new ConcurrentHashMap<Integer, ToolCallBuilder>();
    protected StringBuilder aggregationMessageContent = new StringBuilder();
    public boolean in_thinking;
    public boolean has_reasoning_field;

    public ChatResponseDefault(boolean stream) {
        this.stream = stream;
    }

    @Override
    public String getResponseData() {
        return this.responseData;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public ChatException getError() {
        return this.error;
    }

    public boolean hasToolCallBuilders() {
        return Utils.isNotEmpty(this.toolCallBuilders);
    }

    @Override
    public List<ChatChoice> getChoices() {
        return this.choices;
    }

    @Override
    public boolean hasChoices() {
        return Utils.isNotEmpty(this.choices);
    }

    @Override
    public ChatChoice lastChoice() {
        return this.choices.get(this.choices.size() - 1);
    }

    @Override
    public AssistantMessage getMessage() {
        if (this.hasChoices()) {
            return this.lastChoice().getMessage();
        }
        return null;
    }

    @Override
    public AssistantMessage getAggregationMessage() {
        if (this.hasChoices()) {
            if (this.stream) {
                return new AssistantMessage(this.aggregationMessageContent.toString(), this.lastChoice().getMessage().isThinking());
            }
            return this.lastChoice().getMessage();
        }
        if (this.aggregationMessageContent.length() > 0) {
            return new AssistantMessage(this.aggregationMessageContent.toString(), false);
        }
        return null;
    }

    @Override
    public boolean hasContent() {
        return this.getContent() != null;
    }

    @Override
    public String getContent() {
        if (this.hasChoices()) {
            return this.lastChoice().getMessage().getContent();
        }
        return null;
    }

    @Override
    public @Nullable AiUsage getUsage() {
        return this.usage;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean isStream() {
        return this.stream;
    }

    public void reset() {
        this.error = null;
        this.choices.clear();
    }

    public void setResponseData(String responseData) {
        this.responseData = responseData;
    }

    public void addChoice(ChatChoice choice) {
        this.choices.add(choice);
    }

    public void setError(ChatException error) {
        this.error = error;
    }

    public void setUsage(AiUsage usage) {
        this.usage = usage;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }
}

