/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.ai.util.ProxyDesc;
import org.noear.solon.net.http.HttpUtils;

public class AiConfig {
    protected String apiUrl;
    protected String apiKey;
    protected String provider;
    protected String model;
    protected final Map<String, String> headers = new LinkedHashMap<String, String>();
    protected Duration timeout = Duration.ofSeconds(60L);
    protected ProxyDesc proxy;
    protected Proxy proxyInstance;

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getModel() {
        return this.model;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public Proxy getProxy() {
        if (this.proxyInstance == null && this.proxy != null) {
            this.proxyInstance = new Proxy(this.proxy.type, new InetSocketAddress(this.proxy.host, this.proxy.port));
        }
        return this.proxyInstance;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setHeaders(Map<String, String> headers) {
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setTimeout(Duration timeout) {
        if (timeout != null) {
            this.timeout = timeout;
        }
    }

    public void setProxy(Proxy proxyInstance) {
        this.proxyInstance = proxyInstance;
        this.proxy = null;
    }

    public HttpUtils createHttpUtils() {
        HttpUtils httpUtils = HttpUtils.http((String)this.getApiUrl()).timeout((int)this.getTimeout().getSeconds());
        if (this.getProxy() != null) {
            httpUtils.proxy(this.getProxy());
        }
        if (Utils.isNotEmpty((String)this.getApiKey())) {
            httpUtils.header("Authorization", "Bearer " + this.getApiKey());
        }
        httpUtils.headers(this.getHeaders());
        return httpUtils;
    }

    public String toString() {
        return "AiConfig{apiUrl='" + this.apiUrl + '\'' + ", apiKey='" + this.apiKey + '\'' + ", provider='" + this.provider + '\'' + ", model='" + this.model + '\'' + ", headers=" + this.headers + ", timeout=" + this.timeout + ", proxy=" + this.getProxy() + '}';
    }
}

