/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema.validate.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;
import org.noear.snack4.ONode;
import org.noear.snack4.jsonschema.JsonSchemaException;
import org.noear.snack4.jsonschema.validate.PathTracker;
import org.noear.snack4.jsonschema.validate.ValidationRule;

public class StringConstraintRule
implements ValidationRule {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[a-zA-Z0-9_!#$%&'*+/=?`{|}~^.-]+@[a-zA-Z0-9.-]+$");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_DATE;
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ISO_TIME;
    private final Integer minLength;
    private final Integer maxLength;
    private final String patternString;
    private final String format;
    private final Pattern compiledPattern;

    public StringConstraintRule(ONode schemaNode) {
        this.minLength = schemaNode.hasKey("minLength") ? schemaNode.get("minLength").getInt() : null;
        this.maxLength = schemaNode.hasKey("maxLength") ? schemaNode.get("maxLength").getInt() : null;
        this.patternString = schemaNode.hasKey("pattern") ? schemaNode.get("pattern").getString() : null;
        this.format = schemaNode.hasKey("format") ? schemaNode.get("format").getString() : null;
        this.compiledPattern = this.patternString != null ? Pattern.compile(this.patternString) : null;
    }

    @Override
    public void validate(ONode data, PathTracker path) throws JsonSchemaException {
        if (!data.isString()) {
            return;
        }
        String value = data.getString();
        String currentPath = path.currentPath();
        if (this.minLength != null && value.length() < this.minLength) {
            throw new JsonSchemaException("String length " + value.length() + " < minLength(" + this.minLength + ") at " + currentPath);
        }
        if (this.maxLength != null && value.length() > this.maxLength) {
            throw new JsonSchemaException("String length " + value.length() + " > maxLength(" + this.maxLength + ") at " + currentPath);
        }
        if (this.compiledPattern != null && !this.compiledPattern.matcher(value).matches()) {
            throw new JsonSchemaException("String does not match pattern: " + this.patternString + " at " + currentPath);
        }
        if (this.format != null) {
            if (this.format.equals("uri")) {
                if (!this.isValidUri(value)) {
                    throw new JsonSchemaException("String is not a valid URI format: " + value + " at " + currentPath);
                }
            } else if (this.format.equals("date-time")) {
                if (!this.isValidDateTime(value)) {
                    throw new JsonSchemaException("String is not a valid date-time format (RFC 3339): " + value + " at " + currentPath);
                }
            } else if (this.format.equals("date")) {
                if (!this.isValidDate(value)) {
                    throw new JsonSchemaException("String is not a valid date format (RFC 3339): " + value + " at " + currentPath);
                }
            } else if (this.format.equals("time")) {
                if (!this.isValidTime(value)) {
                    throw new JsonSchemaException("String is not a valid time format (RFC 3339): " + value + " at " + currentPath);
                }
            } else if (this.format.equals("email") && !this.isValidEmail(value)) {
                throw new JsonSchemaException("String is not a valid email format: " + value + " at " + currentPath);
            }
        }
    }

    private boolean isValidUri(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        try {
            new URI(value);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private boolean isValidDateTime(String value) {
        try {
            DATE_TIME_FORMATTER.parse(value);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private boolean isValidDate(String value) {
        try {
            DATE_FORMATTER.parse(value);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private boolean isValidTime(String value) {
        try {
            TIME_FORMATTER.parse(value);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private boolean isValidEmail(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        return EMAIL_PATTERN.matcher(value).matches();
    }
}

