/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema.validate.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.jsonschema.JsonSchemaException;
import org.noear.snack4.jsonschema.validate.PathTracker;
import org.noear.snack4.jsonschema.validate.ValidationRule;
import org.noear.snack4.jsonschema.validate.impl.EnumRule;
import org.noear.snack4.jsonschema.validate.impl.NumericConstraintRule;
import org.noear.snack4.jsonschema.validate.impl.StringConstraintRule;
import org.noear.snack4.jsonschema.validate.impl.TypeRule;

public class PropertyNamesRule
implements ValidationRule {
    private final List<ValidationRule> compiledNameRules = new ArrayList<ValidationRule>();
    private final ONode propertyNamesSchema;
    private final String expectedType;
    private final boolean hasStringConstraints;
    private final boolean hasNumericConstraints;

    public PropertyNamesRule(ONode schemaNode) {
        this.propertyNamesSchema = schemaNode.get("propertyNames");
        this.expectedType = this.getExpectedType();
        this.hasStringConstraints = this.propertyNamesSchema.hasKey("minLength") || this.propertyNamesSchema.hasKey("maxLength") || this.propertyNamesSchema.hasKey("pattern") || this.propertyNamesSchema.hasKey("format");
        boolean bl = this.hasNumericConstraints = this.propertyNamesSchema.hasKey("minimum") || this.propertyNamesSchema.hasKey("maximum") || this.propertyNamesSchema.hasKey("exclusiveMinimum") || this.propertyNamesSchema.hasKey("exclusiveMaximum");
        if (this.propertyNamesSchema.hasKey("type")) {
            this.compiledNameRules.add(new TypeRule(this.propertyNamesSchema.get("type")));
        }
        if (this.hasStringConstraints) {
            this.compiledNameRules.add(new StringConstraintRule(this.propertyNamesSchema));
        }
        if (this.hasNumericConstraints) {
            this.compiledNameRules.add(new NumericConstraintRule(this.propertyNamesSchema));
        }
        if (this.propertyNamesSchema.hasKey("enum")) {
            this.compiledNameRules.add(new EnumRule(this.propertyNamesSchema.get("enum")));
        }
    }

    @Override
    public void validate(ONode data, PathTracker path) throws JsonSchemaException {
        if (!data.isObject()) {
            return;
        }
        if (this.compiledNameRules.isEmpty()) {
            return;
        }
        for (String propName : data.getObject().keySet()) {
            ONode nameNode = this.createNameNode(propName);
            String currentPath = path.currentPath();
            try {
                for (ValidationRule rule : this.compiledNameRules) {
                    rule.validate(nameNode, path);
                }
            }
            catch (JsonSchemaException e) {
                throw new JsonSchemaException("Property name '" + propName + "' failed validation. " + e.getMessage(), currentPath, propName);
            }
        }
    }

    private String getExpectedType() {
        ONode typeNode;
        if (this.propertyNamesSchema.hasKey("type") && (typeNode = this.propertyNamesSchema.get("type")).isString()) {
            return typeNode.getString();
        }
        return null;
    }

    private ONode createNameNode(String propName) {
        if ("integer".equals(this.expectedType) || "number".equals(this.expectedType)) {
            try {
                double value = Double.parseDouble(propName);
                if ("integer".equals(this.expectedType) && value != Math.floor(value)) {
                    return ONode.ofBean((Object)propName, (Feature[])new Feature[0]);
                }
                if (value == Math.floor(value)) {
                    return ONode.ofBean((Object)((long)value), (Feature[])new Feature[0]);
                }
                return ONode.ofBean((Object)value, (Feature[])new Feature[0]);
            }
            catch (NumberFormatException e) {
                return ONode.ofBean((Object)propName, (Feature[])new Feature[0]);
            }
        }
        return ONode.ofBean((Object)propName, (Feature[])new Feature[0]);
    }

    public String toString() {
        return "PropertyNamesRule{rules=" + this.compiledNameRules.stream().map(Object::toString).collect(Collectors.joining(", ")) + '}';
    }
}

