/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema.validate.impl;

import org.noear.snack4.ONode;
import org.noear.snack4.jsonschema.JsonSchemaException;
import org.noear.snack4.jsonschema.validate.PathTracker;
import org.noear.snack4.jsonschema.validate.ValidationRule;

public class NumericConstraintRule
implements ValidationRule {
    private final Double minimum;
    private final Double maximum;
    private final Double exclusiveMinimum;
    private final Double exclusiveMaximum;

    public NumericConstraintRule(ONode schemaNode) {
        this.minimum = schemaNode.hasKey("minimum") ? schemaNode.get("minimum").getDouble() : null;
        this.maximum = schemaNode.hasKey("maximum") ? schemaNode.get("maximum").getDouble() : null;
        this.exclusiveMinimum = schemaNode.hasKey("exclusiveMinimum") ? schemaNode.get("exclusiveMinimum").getDouble() : null;
        this.exclusiveMaximum = schemaNode.hasKey("exclusiveMaximum") ? schemaNode.get("exclusiveMaximum").getDouble() : null;
    }

    @Override
    public void validate(ONode data, PathTracker path) throws JsonSchemaException {
        if (!data.isNumber()) {
            return;
        }
        double value = data.getDouble();
        String currentPath = path.currentPath();
        if (this.minimum != null && value < this.minimum) {
            throw new JsonSchemaException("Value " + value + " < minimum(" + this.minimum + ") at " + currentPath);
        }
        if (this.maximum != null && value > this.maximum) {
            throw new JsonSchemaException("Value " + value + " > maximum(" + this.maximum + ") at " + currentPath);
        }
        if (this.exclusiveMinimum != null && value <= this.exclusiveMinimum) {
            throw new JsonSchemaException("Value " + value + " <= exclusiveMinimum(" + this.exclusiveMinimum + ") at " + currentPath);
        }
        if (this.exclusiveMaximum != null && value >= this.exclusiveMaximum) {
            throw new JsonSchemaException("Value " + value + " >= exclusiveMaximum(" + this.exclusiveMaximum + ") at " + currentPath);
        }
    }
}

