/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema.validate.impl;

import java.util.HashSet;
import java.util.Set;
import org.noear.snack4.ONode;
import org.noear.snack4.jsonschema.JsonSchemaException;
import org.noear.snack4.jsonschema.validate.PathTracker;
import org.noear.snack4.jsonschema.validate.ValidationRule;

public class EnumRule
implements ValidationRule {
    private final Set<ONode> allowedValues = new HashSet<ONode>();

    public EnumRule(ONode enumNode) {
        if (enumNode.isArray()) {
            for (ONode value : enumNode.getArray()) {
                this.allowedValues.add(value);
            }
        }
    }

    @Override
    public void validate(ONode data, PathTracker path) throws JsonSchemaException {
        if (!this.allowedValues.contains(data)) {
            throw new JsonSchemaException("Value '" + data.toJson() + "' not in enum list " + this.allowedValues + " at " + path.currentPath());
        }
    }

    public String toString() {
        return "EnumRule{allowedValues=" + this.allowedValues + '}';
    }
}

