/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema.validate.impl;

import java.util.HashSet;
import java.util.List;
import org.noear.snack4.ONode;
import org.noear.snack4.jsonschema.JsonSchemaException;
import org.noear.snack4.jsonschema.validate.PathTracker;
import org.noear.snack4.jsonschema.validate.ValidationRule;

public class ArrayConstraintRule
implements ValidationRule {
    private final Integer minItems;
    private final Integer maxItems;
    private final boolean uniqueItems;

    public ArrayConstraintRule(ONode schemaNode) {
        this.minItems = schemaNode.hasKey("minItems") ? schemaNode.get("minItems").getInt() : null;
        this.maxItems = schemaNode.hasKey("maxItems") ? schemaNode.get("maxItems").getInt() : null;
        this.uniqueItems = schemaNode.hasKey("uniqueItems") && schemaNode.get("uniqueItems").getBoolean() != false;
    }

    @Override
    public void validate(ONode data, PathTracker path) throws JsonSchemaException {
        if (!data.isArray()) {
            return;
        }
        List items = data.getArray();
        int size = items.size();
        String currentPath = path.currentPath();
        if (this.minItems != null && size < this.minItems) {
            throw new JsonSchemaException("Array length " + size + " < minItems(" + this.minItems + ")", currentPath, data.toJson());
        }
        if (this.maxItems != null && size > this.maxItems) {
            throw new JsonSchemaException("Array length " + size + " > maxItems(" + this.maxItems + ")", currentPath, data.toJson());
        }
        if (this.uniqueItems) {
            HashSet<String> set = new HashSet<String>(size);
            for (ONode item : items) {
                if (set.add(item.toJson())) continue;
                throw new JsonSchemaException("Array contains duplicate items", currentPath, data.toJson());
            }
        }
    }
}

