/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema.validate.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.noear.snack4.ONode;
import org.noear.snack4.jsonschema.JsonSchemaException;
import org.noear.snack4.jsonschema.validate.JsonSchemaValidator;
import org.noear.snack4.jsonschema.validate.PathTracker;
import org.noear.snack4.jsonschema.validate.ValidationRule;

public class AdditionalPropertiesRule
implements ValidationRule {
    private final boolean allowAdditional;
    private final JsonSchemaValidator additionalSchemaValidator;
    private final Set<String> definedProperties = new HashSet<String>();
    private final Map<String, Pattern> compiledPatterns;

    public AdditionalPropertiesRule(ONode schemaNode) {
        ONode additionalPropsNode = schemaNode.get("additionalProperties");
        ONode patternPropertiesNode = schemaNode.getOrNull("patternProperties");
        if (additionalPropsNode.isBoolean()) {
            this.allowAdditional = additionalPropsNode.getBoolean();
            this.additionalSchemaValidator = null;
        } else if (additionalPropsNode.isObject()) {
            this.allowAdditional = true;
            this.additionalSchemaValidator = new JsonSchemaValidator(additionalPropsNode);
        } else {
            this.allowAdditional = true;
            this.additionalSchemaValidator = null;
        }
        if (schemaNode.hasKey("properties")) {
            this.definedProperties.addAll(schemaNode.get("properties").getObject().keySet());
        }
        if (patternPropertiesNode != null && patternPropertiesNode.isObject()) {
            this.compiledPatterns = new HashMap<String, Pattern>();
            for (String patternStr : patternPropertiesNode.getObject().keySet()) {
                this.compiledPatterns.put(patternStr, Pattern.compile(patternStr));
            }
        } else {
            this.compiledPatterns = Collections.emptyMap();
        }
    }

    private boolean isPatternDefined(String propertyName) {
        for (Pattern pattern : this.compiledPatterns.values()) {
            if (!pattern.matcher(propertyName).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validate(ONode data, PathTracker path) throws JsonSchemaException {
        if (!data.isObject()) {
            return;
        }
        String currentPath = path.currentPath();
        for (String key : data.getObject().keySet()) {
            if (this.definedProperties.contains(key) || this.isPatternDefined(key)) continue;
            if (!this.allowAdditional) {
                throw new JsonSchemaException("Additional property '" + key + "' is not allowed", currentPath, key);
            }
            if (this.additionalSchemaValidator == null) continue;
            path.enterProperty(key);
            try {
                this.additionalSchemaValidator.validate(data.get(key));
            }
            catch (JsonSchemaException e) {
                throw new JsonSchemaException("Additional property '" + key + "' failed validation: " + e.getMessage(), currentPath, key, (Throwable)((Object)e));
            }
            path.exit();
        }
    }
}

