/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema.validate;

import java.util.ArrayDeque;
import java.util.Deque;

public class PathTracker {
    private final StringBuilder pathBuilder;
    private final Deque<Integer> lengthStack = new ArrayDeque<Integer>();

    public PathTracker() {
        this.pathBuilder = new StringBuilder("$");
        this.lengthStack.push(this.pathBuilder.length());
    }

    public PathTracker(String rootPath) {
        this.pathBuilder = new StringBuilder(rootPath);
        this.lengthStack.push(this.pathBuilder.length());
    }

    public void enterProperty(String property) {
        this.pathBuilder.append('.').append(property);
        this.lengthStack.push(this.pathBuilder.length());
    }

    public void enterIndex(int arrayIndex) {
        this.pathBuilder.append('[').append(arrayIndex).append(']');
        this.lengthStack.push(this.pathBuilder.length());
    }

    public String currentPath() {
        return this.pathBuilder.toString();
    }

    public void exit() {
        if (this.lengthStack.size() > 1) {
            this.lengthStack.pop();
            this.pathBuilder.setLength(this.lengthStack.peek());
        }
    }

    public static PathTracker begin() {
        return new PathTracker();
    }
}

