/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema.validate;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.snack4.ONode;
import org.noear.snack4.jsonschema.JsonSchemaException;
import org.noear.snack4.jsonschema.validate.CompiledRule;
import org.noear.snack4.jsonschema.validate.PathTracker;
import org.noear.snack4.jsonschema.validate.ValidationRule;
import org.noear.snack4.jsonschema.validate.impl.AdditionalPropertiesRule;
import org.noear.snack4.jsonschema.validate.impl.ArrayConstraintRule;
import org.noear.snack4.jsonschema.validate.impl.EnumRule;
import org.noear.snack4.jsonschema.validate.impl.NumericConstraintRule;
import org.noear.snack4.jsonschema.validate.impl.PropertyNamesRule;
import org.noear.snack4.jsonschema.validate.impl.RequiredRule;
import org.noear.snack4.jsonschema.validate.impl.StringConstraintRule;
import org.noear.snack4.jsonschema.validate.impl.TypeRule;

public class JsonSchemaValidator {
    private final ONode schema;
    private final Map<String, CompiledRule> compiledRules;
    private final Map<ONode, Map<String, CompiledRule>> fragmentCache = new ConcurrentHashMap<ONode, Map<String, CompiledRule>>();

    public JsonSchemaValidator(ONode schema) {
        if (!schema.isObject()) {
            throw new IllegalArgumentException("Schema must be a JSON object");
        }
        this.schema = schema;
        this.compiledRules = this.compileSchema(schema);
    }

    public String toString() {
        return String.valueOf(this.compiledRules);
    }

    public String toJson() {
        return this.schema.toJson();
    }

    public void validate(ONode data) throws JsonSchemaException {
        this.validateNode(this.schema, data, PathTracker.begin(), null);
    }

    public void validate(ONode data, PathTracker path) throws JsonSchemaException {
        this.validateNode(this.schema, data, path, null);
    }

    private void validateNode(ONode schemaNode, ONode dataNode, PathTracker path, String wildcardPath) throws JsonSchemaException {
        CompiledRule wildcardRule;
        CompiledRule specificRule = this.compiledRules.get(path.currentPath());
        if (specificRule != null) {
            specificRule.validate(dataNode, path);
        }
        if (wildcardPath != null && (wildcardRule = this.compiledRules.get(wildcardPath)) != null) {
            wildcardRule.validate(dataNode, path);
        }
        if (dataNode.isObject() && schemaNode.hasKey("properties")) {
            this.validateProperties(schemaNode, dataNode, path);
        }
        if (dataNode.isArray() && schemaNode.hasKey("items")) {
            this.validateArrayItems(schemaNode, dataNode, path);
        }
        this.validateConditional(schemaNode, dataNode, path);
    }

    private void validateArrayItems(ONode schemaNode, ONode dataNode, PathTracker path) throws JsonSchemaException {
        ONode itemsSchema = schemaNode.get("items");
        List items = dataNode.getArray();
        String wildcardPath = path.currentPath() + "[*]";
        for (int i = 0; i < items.size(); ++i) {
            path.enterIndex(i);
            this.validateNode(itemsSchema, (ONode)items.get(i), path, wildcardPath);
            path.exit();
        }
    }

    private void validateProperties(ONode schemaNode, ONode dataNode, PathTracker path) throws JsonSchemaException {
        ONode propertiesNode = schemaNode.get("properties");
        Map properties = propertiesNode.getObject();
        Map dataObj = dataNode.getObject();
        for (Map.Entry propEntry : properties.entrySet()) {
            String propName = (String)propEntry.getKey();
            if (!dataObj.containsKey(propName)) continue;
            path.enterProperty(propName);
            this.validateNode((ONode)propEntry.getValue(), (ONode)dataObj.get(propName), path, null);
            path.exit();
        }
    }

    private void validateConditional(ONode schemaNode, ONode dataNode, PathTracker path) throws JsonSchemaException {
        this.validateConditionalGroup(schemaNode, "anyOf", dataNode, path);
        this.validateConditionalGroup(schemaNode, "oneOf", dataNode, path);
    }

    private void validateConditionalGroup(ONode schemaNode, String key, ONode dataNode, PathTracker path) throws JsonSchemaException {
        if (!schemaNode.hasKey(key)) {
            return;
        }
        List schemas = schemaNode.get(key).getArray();
        int matchCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (ONode subSchema : schemas) {
            Map tempRules = this.fragmentCache.computeIfAbsent(subSchema, s -> this.compileSchemaFragment((ONode)s));
            PathTracker tempPath = PathTracker.begin();
            try {
                this.validateNodeWithRules(subSchema, dataNode, tempPath, tempRules);
                ++matchCount;
            }
            catch (JsonSchemaException e) {
                errorMessages.add(e.getMessage());
            }
        }
        if (key.equals("anyOf") && matchCount == 0) {
            throw new JsonSchemaException("Failed to satisfy anyOf constraints at " + path.currentPath() + ". Errors: " + errorMessages);
        }
        if (key.equals("oneOf") && matchCount != 1) {
            throw new JsonSchemaException("Must satisfy exactly one of oneOf constraints (found " + matchCount + ") at " + path.currentPath() + ". Errors: " + errorMessages);
        }
    }

    private Map<String, CompiledRule> compileSchemaFragment(ONode schemaFragment) {
        LinkedHashMap<String, CompiledRule> rules = new LinkedHashMap<String, CompiledRule>();
        this.compileSchemaRecursive(schemaFragment, rules, PathTracker.begin());
        return rules;
    }

    private void validateNodeWithRules(ONode schemaNode, ONode dataNode, PathTracker path, Map<String, CompiledRule> rules) throws JsonSchemaException {
        CompiledRule rule = rules.get(path.currentPath());
        if (rule != null) {
            rule.validate(dataNode, path);
        }
        if (dataNode.isObject() && schemaNode.hasKey("properties")) {
            this.validatePropertiesWithRules(schemaNode, dataNode, path, rules);
        }
        if (dataNode.isArray() && schemaNode.hasKey("items")) {
            this.validateArrayItemsWithRules(schemaNode, dataNode, path, rules);
        }
        this.validateConditionalWithRules(schemaNode, "anyOf", dataNode, path, rules);
        this.validateConditionalWithRules(schemaNode, "oneOf", dataNode, path, rules);
    }

    private void validatePropertiesWithRules(ONode schemaNode, ONode dataNode, PathTracker path, Map<String, CompiledRule> rules) throws JsonSchemaException {
        ONode propertiesNode = schemaNode.get("properties");
        Map properties = propertiesNode.getObject();
        Map dataObj = dataNode.getObject();
        for (Map.Entry propEntry : properties.entrySet()) {
            String propName = (String)propEntry.getKey();
            if (!dataObj.containsKey(propName)) continue;
            path.enterProperty(propName);
            this.validateNodeWithRules((ONode)propEntry.getValue(), (ONode)dataObj.get(propName), path, rules);
            path.exit();
        }
    }

    private void validateArrayItemsWithRules(ONode schemaNode, ONode dataNode, PathTracker path, Map<String, CompiledRule> rules) throws JsonSchemaException {
        ONode itemsSchema = schemaNode.get("items");
        List items = dataNode.getArray();
        for (int i = 0; i < items.size(); ++i) {
            path.enterIndex(i);
            this.validateNodeWithRules(itemsSchema, (ONode)items.get(i), path, rules);
            path.exit();
        }
    }

    private void validateConditionalWithRules(ONode schemaNode, String key, ONode dataNode, PathTracker path, Map<String, CompiledRule> rules) throws JsonSchemaException {
        if (!schemaNode.hasKey(key)) {
            return;
        }
        List schemas = schemaNode.get(key).getArray();
        int matchCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (ONode subSchema : schemas) {
            Map tempRules = this.fragmentCache.computeIfAbsent(subSchema, s -> this.compileSchemaFragment((ONode)s));
            PathTracker tempPath = PathTracker.begin();
            try {
                this.validateNodeWithRules(subSchema, dataNode, tempPath, tempRules);
                ++matchCount;
            }
            catch (JsonSchemaException e) {
                errorMessages.add(e.getMessage());
            }
        }
        if (key.equals("anyOf") && matchCount == 0) {
            throw new JsonSchemaException("Failed to satisfy anyOf constraints at " + path.currentPath() + ". Errors: " + errorMessages);
        }
        if (key.equals("oneOf") && matchCount != 1) {
            throw new JsonSchemaException("Must satisfy exactly one of oneOf constraints (found " + matchCount + ") at " + path.currentPath() + ". Errors: " + errorMessages);
        }
    }

    private Map<String, CompiledRule> compileSchema(ONode schema) {
        LinkedHashMap<String, CompiledRule> rules = new LinkedHashMap<String, CompiledRule>();
        this.compileSchemaRecursive(schema, rules, PathTracker.begin());
        return rules;
    }

    private void compileSchemaRecursive(ONode schemaNode, Map<String, CompiledRule> rules, PathTracker path) {
        if (schemaNode.hasKey("$ref")) {
            String refPath = schemaNode.get("$ref").getString();
            ONode referencedSchema = this.resolveRef(refPath);
            if (referencedSchema != null) {
                this.compileSchemaRecursive(referencedSchema, rules, path);
                return;
            }
            throw new JsonSchemaException("Could not resolve $ref: " + refPath, path.currentPath(), refPath);
        }
        if (schemaNode.hasKey("allOf")) {
            for (ONode subSchema : schemaNode.get("allOf").getArray()) {
                this.compileSchemaRecursive(subSchema, rules, path);
            }
        }
        ArrayList<ValidationRule> localRules = new ArrayList<ValidationRule>();
        if (schemaNode.hasKey("type")) {
            localRules.add(new TypeRule(schemaNode.get("type")));
        }
        if (schemaNode.hasKey("enum")) {
            localRules.add(new EnumRule(schemaNode.get("enum")));
        }
        if (schemaNode.hasKey("required")) {
            localRules.add(new RequiredRule(schemaNode.get("required")));
        }
        if (schemaNode.hasKey("minLength") || schemaNode.hasKey("maxLength") || schemaNode.hasKey("pattern")) {
            localRules.add(new StringConstraintRule(schemaNode));
        }
        if (schemaNode.hasKey("minimum") || schemaNode.hasKey("maximum") || schemaNode.hasKey("exclusiveMinimum") || schemaNode.hasKey("exclusiveMaximum")) {
            localRules.add(new NumericConstraintRule(schemaNode));
        }
        if (schemaNode.hasKey("minItems") || schemaNode.hasKey("maxItems")) {
            localRules.add(new ArrayConstraintRule(schemaNode));
        }
        if (schemaNode.hasKey("additionalProperties")) {
            localRules.add(new AdditionalPropertiesRule(schemaNode));
        }
        if (schemaNode.hasKey("propertyNames")) {
            localRules.add(new PropertyNamesRule(schemaNode));
        }
        if (!localRules.isEmpty()) {
            CompiledRule existingRule = rules.get(path.currentPath());
            if (existingRule != null) {
                existingRule.addRules(localRules);
            } else {
                rules.put(path.currentPath(), new CompiledRule(localRules));
            }
        }
        if (schemaNode.hasKey("properties")) {
            ONode propsNode = schemaNode.get("properties");
            for (Map.Entry kv : propsNode.getObject().entrySet()) {
                path.enterProperty((String)kv.getKey());
                this.compileSchemaRecursive((ONode)kv.getValue(), rules, path);
                path.exit();
            }
        }
        if (schemaNode.hasKey("patternProperties")) {
            ONode patternsNode = schemaNode.get("patternProperties");
            for (Map.Entry kv : patternsNode.getObject().entrySet()) {
                this.compileSchemaRecursive((ONode)kv.getValue(), rules, path);
            }
        }
        if (schemaNode.hasKey("items")) {
            ONode itemsSchema = schemaNode.get("items");
            String itemsPath = path.currentPath() + "[*]";
            this.compileSchemaRecursive(itemsSchema, rules, new PathTracker(itemsPath));
        }
    }

    private ONode resolveRef(String refPath) {
        if (refPath == null || !refPath.startsWith("#/")) {
            return null;
        }
        String[] parts = refPath.substring(2).split("/");
        ONode current = this.schema;
        for (String part : parts) {
            if (current == null) {
                return null;
            }
            try {
                part = URLDecoder.decode(part, "UTF-8");
                part = part.replace("~1", "/").replace("~0", "~");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 encoding not supported", e);
            }
            current = current.isArray() && part.matches("\\d+") ? current.get(Integer.parseInt(part)) : current.get(part);
        }
        return current;
    }
}

