/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema;

import java.lang.reflect.Type;
import java.util.Objects;
import org.noear.eggg.TypeEggg;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.jsonschema.JsonSchemaException;
import org.noear.snack4.jsonschema.SchemaVersion;
import org.noear.snack4.jsonschema.generate.JsonSchemaGenerator;
import org.noear.snack4.jsonschema.generate.MapperLib;
import org.noear.snack4.jsonschema.generate.SchemaMapper;
import org.noear.snack4.jsonschema.generate.SchemaPatternMapper;
import org.noear.snack4.jsonschema.validate.JsonSchemaValidator;
import org.noear.snack4.util.Asserts;

public class JsonSchema {
    public static final JsonSchema DEFAULT = JsonSchema.builder().build();
    private final SchemaVersion version;
    private final boolean enableDefinitions;
    private final boolean printVersion;
    private final MapperLib definerLib = MapperLib.newInstance();

    public JsonSchema(SchemaVersion version, boolean enableDefinitions, boolean printVersion) {
        this.version = version;
        this.enableDefinitions = enableDefinitions;
        this.printVersion = printVersion;
    }

    public SchemaVersion getVersion() {
        return this.version;
    }

    public boolean isEnableDefinitions() {
        return this.enableDefinitions;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    public <T> void addMapper(SchemaPatternMapper<T> mapper) {
        this.definerLib.addMapper(mapper);
    }

    public <T> void addMapper(Class<T> type, SchemaMapper<T> mapper) {
        if (mapper instanceof SchemaPatternMapper) {
            this.addMapper((SchemaPatternMapper)mapper);
        }
        this.definerLib.addMapper(type, mapper);
    }

    public SchemaMapper getMapper(TypeEggg typeEggg) {
        return this.definerLib.getMapper(typeEggg);
    }

    public JsonSchemaGenerator createGenerator(Type type) {
        return new JsonSchemaGenerator(type, this);
    }

    public JsonSchemaGenerator createGenerator(TypeEggg type) {
        return new JsonSchemaGenerator(type, this);
    }

    public JsonSchemaValidator createValidator(Type type) {
        Objects.requireNonNull(type, "type");
        ONode oNode = this.createGenerator(type).generate();
        if (oNode == null) {
            throw new JsonSchemaException("The type jsonSchema generation failed: " + type.toString());
        }
        return new JsonSchemaValidator(oNode);
    }

    public JsonSchemaValidator createValidator(TypeEggg typeEggg) {
        Objects.requireNonNull(typeEggg, "typeEggg");
        ONode oNode = this.createGenerator(typeEggg).generate();
        if (oNode == null) {
            throw new JsonSchemaException("The type jsonSchema generation failed: " + typeEggg.toString());
        }
        return new JsonSchemaValidator(oNode);
    }

    public JsonSchemaValidator createValidator(String jsonSchema) {
        if (Asserts.isEmpty((String)jsonSchema)) {
            throw new IllegalArgumentException("jsonSchema is empty");
        }
        return new JsonSchemaValidator(ONode.ofJson((String)jsonSchema, (Feature[])new Feature[0]));
    }

    public JsonSchemaValidator createValidator(ONode jsonSchema) {
        Objects.requireNonNull(jsonSchema, "jsonSchema");
        if (!jsonSchema.isObject()) {
            throw new IllegalArgumentException("jsonSchema is invalid");
        }
        return new JsonSchemaValidator(jsonSchema);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SchemaVersion version = SchemaVersion.DRAFT_7;
        private boolean enableDefinitions;
        private boolean printVersion;

        public Builder version(SchemaVersion version) {
            this.version = version;
            return this;
        }

        public Builder enableDefinitions(boolean enableDefinitions) {
            this.enableDefinitions = enableDefinitions;
            return this;
        }

        public Builder printVersion(boolean printVersion) {
            this.printVersion = printVersion;
            return this;
        }

        public JsonSchema build() {
            return new JsonSchema(this.version, this.enableDefinitions, this.printVersion);
        }
    }
}

