/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.util.JdbcUrl;
import org.openide.util.NbBundle;

public class DriverListUtil {
    private static final List<JdbcUrl> templateUrls = new ArrayList<JdbcUrl>(61);

    private DriverListUtil() {
    }

    private static void add(JdbcUrl url) {
        templateUrls.add(url);
    }

    private static void add(String name, String type, String driverClassName, String urlTemplate) {
        templateUrls.add(new JdbcUrl(name, name, driverClassName, type, urlTemplate));
    }

    private static void add(String name, String type, String driverClassName, String urlTemplate, boolean parseUrl) {
        templateUrls.add(new JdbcUrl(name, name, driverClassName, type, urlTemplate, parseUrl));
    }

    private static void add(String name, String driverClassName, String urlTemplate) {
        DriverListUtil.add(name, null, driverClassName, urlTemplate);
    }

    private static void add(String name, String driverClassName, String urlTemplate, boolean parseUrl) {
        DriverListUtil.add(name, null, driverClassName, urlTemplate, parseUrl);
    }

    public static Set<String> getDrivers() {
        TreeSet<String> drivers = new TreeSet<String>();
        for (JdbcUrl url : templateUrls) {
            drivers.add(url.getClassName());
        }
        return drivers;
    }

    public static List<JdbcUrl> getJdbcUrls(JDBCDriver driver) {
        ArrayList<JdbcUrl> driverUrls = new ArrayList<JdbcUrl>(3);
        for (JdbcUrl url : templateUrls) {
            if (!url.getClassName().equals(driver.getClassName())) continue;
            JdbcUrl newurl = new JdbcUrl(url, driver);
            driverUrls.add(newurl);
        }
        if (driverUrls.isEmpty()) {
            driverUrls.add(new JdbcUrl(driver));
        }
        return new ArrayList<JdbcUrl>(driverUrls);
    }

    static List<JdbcUrl> getJdbcUrls() {
        return templateUrls;
    }

    public static String getName(String driverClass) {
        for (JdbcUrl url : templateUrls) {
            if (!url.getClassName().equals(driverClass)) continue;
            return url.getName();
        }
        return "";
    }

    public static String findFreeName(String name) {
        int i;
        ArrayList<String> names = new ArrayList<String>();
        JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers();
        for (i = 0; i < drivers.length; ++i) {
            names.add(drivers[i].getDisplayName());
        }
        if (names.contains(name)) {
            i = 1;
            while (true) {
                String ret;
                if (!names.contains(ret = name + " (" + i + ")")) {
                    return ret;
                }
                ++i;
            }
        }
        return name;
    }

    static {
        DriverListUtil.add("IBM DB2 (net)", "COM.ibm.db2.jdbc.net.DB2Driver", "jdbc:db2://<HOST>:<PORT>/<DB>");
        DriverListUtil.add("IBM DB2 (local)", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:<DB>");
        DriverListUtil.add("JDBC-ODBC Bridge", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:<DB>");
        DriverListUtil.add("Microsoft SQL Server (Weblogic driver)", "weblogic.jdbc.mssqlserver4.Driver", "jdbc:weblogic:mssqlserver4:<DB>@<HOST>[:<PORT>]");
        DriverListUtil.add("PointBase", "Network Server", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase://<HOST>[:<PORT>]/<DB>");
        DriverListUtil.add("PointBase", "Embedded", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase://embedded[:<PORT>]/<DB>");
        DriverListUtil.add("PointBase", "Mobile Edition", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase:<DB>");
        DriverListUtil.add("Cloudscape", "COM.cloudscape.core.JDBCDriver", "jdbc:cloudscape:<DB>");
        DriverListUtil.add("Cloudscape RMI", "RmiJdbc.RJDriver", "jdbc:rmi://<HOST>[:<PORT>]/jdbc:cloudscape:<DB>");
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_JavaDbEmbedded"), "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:<DB>[;<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_JavaDbNetwork"), "org.apache.derby.jdbc.ClientDriver", "jdbc:derby://<HOST>[:<PORT>]/<DB>[;<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_DB2JCC"), "com.ibm.db2.jcc.DB2Driver", "jdbc:db2://<HOST>:<PORT>/<DB>[:<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_DB2JCC"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_IDS"), "com.ibm.db2.jcc.DB2Driver", "jdbc:ids://<HOST>:<PORT>/<DB>[:<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_DB2JCC"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_Cloudscape"), "com.ibm.db2.jcc.DB2Driver", "jdbc:db2j:net://<HOST>:<PORT>/<DB>[:<ADDITIONAL>]", true);
        DriverListUtil.add("Firebird (JCA/JDBC driver)", "org.firebirdsql.jdbc.FBDriver", "jdbc:firebirdsql:[//<HOST>[:<PORT>]/]<DB>");
        DriverListUtil.add("FirstSQL/J", "Enterprise Server Edition", "COM.FirstSQL.Dbcp.DbcpDriver", "jdbc:dbcp://<HOST>[:<PORT>]");
        DriverListUtil.add("FirstSQL/J", "Professional Edition", "COM.FirstSQL.Dbcp.DbcpDriver", "jdbc:dbcp://local");
        DriverListUtil.add("IBM DB2 (DataDirect Connect for JDBC)", "com.ddtek.jdbc.db2.DB2Driver", "jdbc:datadirect:db2://<HOST>[:<PORT>][;databaseName=<DB>]");
        DriverListUtil.add("IDS Server", "ids.sql.IDSDriver", "jdbc:ids://<HOST>[:<PORT>]/conn?dsn='<DSN>'");
        DriverListUtil.add("Informix Dynamic Server", "com.informix.jdbc.IfxDriver", "jdbc:informix-sqli://<HOST>[:<PORT>]/<DB>:INFORMIXSERVER=<SERVER_NAME>");
        DriverListUtil.add("Informix Dynamic Server (DataDirect Connect for JDBC)", "com.ddtek.jdbc.informix.InformixDriver", "jdbc:datadirect:informix://<HOST>[:<PORT>];informixServer=<SERVER_NAME>;databaseName=<DB>");
        DriverListUtil.add("InstantDB (v3.13 and earlier)", "jdbc.idbDriver", "jdbc:idb:<DB>");
        DriverListUtil.add("InstantDB (v3.14 and later)", "org.enhydra.instantdb.jdbc.idbDriver", "jdbc:idb:<DB>");
        DriverListUtil.add("Interbase (InterClient driver)", "interbase.interclient.Driver", "jdbc:interbase://<HOST>/<DB>");
        DriverListUtil.add("HSQLDB", "Server", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:hsql://<HOST>[:<PORT>]");
        DriverListUtil.add("HSQLDB", "Embedded", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:<DB>");
        DriverListUtil.add("HSQLDB", "Web Server", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:http://<HOST>[:<PORT>]");
        DriverListUtil.add("HSQLDB", "In-Memory", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:.");
        DriverListUtil.add("Hypersonic SQL (v1.2 and earlier)", "hSql.hDriver", "jdbc:HypersonicSQL:<DB>");
        DriverListUtil.add("Hypersonic SQL (v1.3 and later)", "org.hsql.jdbcDriver", "jdbc:HypersonicSQL:<DB>");
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_JTDS"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_ForSQLServer"), "net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sqlserver://<HOST>[:<PORT>][/<DB>][;<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_JTDS"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_ForSybase"), "net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sybase://<HOST>[:<PORT>][/<DB>][;<ADDITIONAL>]", true);
        DriverListUtil.add("Mckoi SQL Database", "Server", "com.mckoi.JDBCDriver", "jdbc:mckoi://<HOST>[:<PORT>]");
        DriverListUtil.add("Mckoi SQL Database", "Embedded", "com.mckoi.JDBCDriver", "jdbc:mckoi:local://<DB>");
        DriverListUtil.add("Microsoft SQL Server (DataDirect Connect for JDBC)", "com.ddtek.jdbc.sqlserver.SQLServerDriver", "jdbc:datadirect:sqlserver://<HOST>[:<PORT>][;databaseName=<DB>]");
        DriverListUtil.add("Microsoft SQL Server (JTurbo driver)", "com.ashna.jturbo.driver.Driver", "jdbc:JTurbo://<HOST>:<PORT>/<DB>");
        DriverListUtil.add("Microsoft SQL Server (Sprinta driver)", "com.inet.tds.TdsDriver", "jdbc:inetdae:<HOST>[:<PORT>]?database=<DB>");
        DriverListUtil.add("Microsoft SQL Server 2000 (Microsoft driver)", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "jdbc:microsoft:sqlserver://<HOST>[:<PORT>][;DatabaseName=<DB>]");
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_MSSQL2005"), "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://[<HOST>[\\<INSTANCE>][:<PORT>]][;databaseName=<DB>][;<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_MySQL"), "com.mysql.jdbc.Driver", "jdbc:mysql://[<HOST>[:<PORT>]][/<DB>][?<ADDITIONAL>]", true);
        DriverListUtil.add("MySQL (MM.MySQL driver)", "org.gjt.mm.mysql.Driver", "jdbc:mysql://<HOST>[:<PORT>]/<DB>");
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleThin"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_SID"), "oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@<HOST>:<PORT>:<SID>[?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleThin"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_Service"), "oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@//<HOST>[:<PORT>][/<SERVICE>][?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleThin"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_TNSName"), "oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@<TNSNAME>[?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleOCI"), "OCI8 " + NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_SID"), "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@<HOST>:<PORT>:<SID>[?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleOCI"), "OCI8 " + NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_Service"), "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@//<HOST>[:<PORT>][/<SERVICE>][?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleOCI"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_TNSName"), "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci:@<TNSNAME>[?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleOCI"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_SID"), "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci:@<HOST>:<PORT>:<SID>[?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleOCI"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_Service"), "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci:@//<HOST>[:<PORT>][/<SERVICE>][?<ADDITIONAL>]", true);
        DriverListUtil.add("Oracle (DataDirect Connect for JDBC)", "com.ddtek.jdbc.oracle.OracleDriver", "jdbc:datadirect:oracle://<HOST>[:<PORT>];SID=<SID>");
        DriverListUtil.add("PostgreSQL (v6.5 and earlier)", "postgresql.Driver", "jdbc:postgresql:[//<HOST>[:<PORT>]/]<DB>[?<ADDITIONAL>]");
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_PostgreSQL"), "org.postgresql.Driver", "jdbc:postgresql:[//<HOST>[:<PORT>]/]<DB>[?<ADDITIONAL>]", true);
        DriverListUtil.add("Quadcap Embeddable Database", "com.quadcap.jdbc.JdbcDriver", "jdbc:qed:<DB>");
        DriverListUtil.add("Sybase (jConnect 4.2 and earlier)", "com.sybase.jdbc.SybDriver", "jdbc:sybase:Tds:<HOST>[:<PORT>]");
        DriverListUtil.add("Sybase (jConnect 5.2)", "com.sybase.jdbc2.jdbc.SybDriver", "jdbc:sybase:Tds:<HOST>[:<PORT>]");
        DriverListUtil.add("Sybase (DataDirect Connect for JDBC)", "com.ddtek.jdbc.sybase.SybaseDriver", "jdbc:datadirect:sybase://<HOST>[:<PORT>][;databaseName=<DB>]");
        DriverListUtil.add("Microsoft SQL Server Driver", "com.sun.sql.jdbc.sqlserver.SQLServerDriver", "jdbc:sun:sqlserver://<HOST>[:<PORT>]");
        DriverListUtil.add("DB2 Driver", "com.sun.sql.jdbc.db2.DB2Driver", "jdbc:sun:db2://<HOST>[:<PORT>];databaseName=<DB>");
        DriverListUtil.add("Oracle Driver", "com.sun.sql.jdbc.oracle.OracleDriver", "jdbc:sun:oracle://<HOST>[:<PORT>][;SID=<SID>]");
        DriverListUtil.add("Sybase Driver", "com.sun.sql.jdbc.sybase.SybaseDriver", "jdbc:sun:sybase://<HOST>[:<PORT]");
        DriverListUtil.add("SQLite", "org.sqlite.JDBC", "jdbc:sqlite:<FILE>");
    }
}

