/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Parameter;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ProcedureParamNode
extends BaseNode {
    private static final String IN = "org/netbeans/modules/db/resources/paramIn.gif";
    private static final String OUT = "org/netbeans/modules/db/resources/paramOut.gif";
    private static final String INOUT = "org/netbeans/modules/db/resources/paramInOut.gif";
    private static final String FOLDER = "ProcedureParam";
    private static final String DBDATATYPE = "DBDatatype";
    private static final String DBDATATYPEDESC = "DBDatatypeDescription";
    private String name = "";
    private String icon = "";
    private final MetadataElementHandle<Parameter> paramHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static ProcedureParamNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        ProcedureParamNode node = new ProcedureParamNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private ProcedureParamNode(NodeDataLookup lookup, NodeProvider provider) {
        super(lookup, FOLDER, provider);
    }

    @Override
    public synchronized void refresh() {
        this.setupNames();
        super.refresh();
    }

    private void setupNames() {
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Parameter parameter = (Parameter)ProcedureParamNode.this.paramHandle.resolve(metaData);
                        if (parameter != null) {
                            ProcedureParamNode.this.name = parameter.getName();
                            switch (parameter.getDirection()) {
                                case IN: {
                                    ProcedureParamNode.this.icon = ProcedureParamNode.IN;
                                    break;
                                }
                                case OUT: {
                                    ProcedureParamNode.this.icon = ProcedureParamNode.OUT;
                                    break;
                                }
                                case INOUT: {
                                    ProcedureParamNode.this.icon = ProcedureParamNode.INOUT;
                                }
                            }
                            ProcedureParamNode.this.updateProperties(parameter);
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, e, true);
            }
        }
    }

    private void updateProperties(Parameter param) {
        PropertySupport.Name ps = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)ps);
        switch (param.getDirection()) {
            case IN: {
                this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureParamNode.class, (String)"In"));
                break;
            }
            case OUT: {
                this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureParamNode.class, (String)"Out"));
                break;
            }
            case INOUT: {
                this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureParamNode.class, (String)"InOut"));
            }
        }
        this.addProperty("Datatype", "DatatypeDescription", String.class, false, param.getType() == null ? "null" : param.getType().toString());
        this.addProperty(DBDATATYPE, DBDATATYPEDESC, String.class, false, param.getTypeName() == null ? "" : param.getTypeName());
    }

    @Override
    protected void initialize() {
        this.setupNames();
    }

    public int getPosition() {
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        final int[] array = new int[1];
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Parameter param = (Parameter)ProcedureParamNode.this.paramHandle.resolve(metaData);
                    array[0] = param.getOrdinalPosition();
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, e, true);
        }
        return array[0];
    }

    @Override
    public String getIconBase() {
        return this.icon;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ProcedureParamNode.class, (String)"ND_ProcedureParam");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProcedureParamNode.class);
    }
}

