/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.action.ConnectUsingDriverAction;
import org.netbeans.modules.db.explorer.dlg.AddConnectionWizard;
import org.netbeans.modules.db.explorer.dlg.NewConnectionPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ConnectionPanel
implements AddConnectionWizard.Panel,
WizardDescriptor.AsynchronousValidatingPanel<AddConnectionWizard>,
WizardDescriptor.FinishablePanel<AddConnectionWizard> {
    private DatabaseConnection databaseConnection;
    private JDBCDriver drv;
    private JDBCDriver oldDriver;
    private static HelpCtx CONNECTION_PANEL_HELPCTX = new HelpCtx(ConnectionPanel.class);
    private NewConnectionPanel component;
    private AddConnectionWizard pw;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private String state;
    private String errorMessage;

    public Component getComponent() {
        if (this.component == null || this.oldDriver != null && !this.oldDriver.equals(this.drv)) {
            this.component = null;
            if (this.pw == null) {
                return null;
            }
            assert (this.pw != null) : "ConnectionPanel must be initialized.";
            this.databaseConnection = new DatabaseConnection();
            assert (this.drv != null) : "JDBCDriver driver cannot be null.";
            this.databaseConnection.setDriver(this.drv.getClassName());
            this.databaseConnection.setDriverName(this.drv.getName());
            this.databaseConnection.setUser(this.pw.getUser());
            this.databaseConnection.setPassword(this.pw.getPassword());
            this.databaseConnection.setDatabase(this.pw.getDatabaseUrl());
            try {
                this.databaseConnection.setDefaultSchema(this.pw.getUser());
            }
            catch (Exception x) {
                Logger.getLogger(ConnectionPanel.class.getName()).log(Level.FINE, x.getLocalizedMessage(), x);
            }
            this.databaseConnection.setRememberPassword(this.databaseConnection.getPassword() != null && !this.databaseConnection.getPassword().isEmpty());
            this.component = new NewConnectionPanel(this.pw, this, this.drv.getClassName(), this.databaseConnection);
            this.oldDriver = this.drv;
            NewConnectionPanel jc = this.component;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", 1);
            jc.putClientProperty("WizardPanel_contentData", this.pw.getSteps());
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.FALSE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.FALSE);
            this.component.setName(this.pw.getSteps()[1]);
            this.fireChangeEvent();
            this.component.checkValid();
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return CONNECTION_PANEL_HELPCTX;
    }

    public boolean isValid() {
        return this.component != null && this.component.valid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        if (this.component == null) {
            return;
        }
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void readSettings(AddConnectionWizard settings) {
        this.pw = settings;
        this.drv = this.pw.getDriver();
    }

    public void storeSettings(AddConnectionWizard settings) {
        this.component.setConnectionInfo();
        this.pw.setCurrentSchema(this.databaseConnection.getUser().toUpperCase());
        this.pw.setDatabaseConnection(this.databaseConnection);
    }

    public void prepareValidation() {
        if (this.component != null) {
            this.component.setWaitingState(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws WizardValidationException {
        try {
            this.state = null;
            PropertyChangeListener connectionListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (!event.getPropertyName().equals("connecting")) {
                        if (event.getPropertyName().equals("failed")) {
                            ConnectionPanel.this.state = event.getPropertyName();
                        } else if (event.getPropertyName().equals("connected")) {
                            try {
                                ConnectionPanel.this.databaseConnection.getConnector().finishConnect(null, ConnectionPanel.this.databaseConnection, ConnectionPanel.this.databaseConnection.getConnection());
                                ConnectionPanel.this.state = event.getPropertyName();
                            }
                            catch (DatabaseException exc) {
                                Logger.getLogger(ConnectionPanel.class.getName()).log(Level.INFO, exc.getLocalizedMessage(), exc);
                                ConnectionPanel.this.state = "failed";
                            }
                        }
                    }
                }
            };
            ExceptionListener excListener = new ExceptionListener(){

                @Override
                public void exceptionOccurred(Exception exc) {
                    if (exc instanceof DDLException) {
                        Logger.getLogger(ConnectionPanel.class.getName()).log(Level.INFO, exc.getLocalizedMessage(), exc.getCause());
                    } else {
                        Logger.getLogger(ConnectionPanel.class.getName()).log(Level.INFO, exc.getLocalizedMessage(), exc);
                    }
                    String message = null;
                    if (exc instanceof ClassNotFoundException) {
                        message = NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"EXC_ClassNotFound", (Object)exc.getMessage());
                    } else {
                        StringBuilder buffer = new StringBuilder();
                        buffer.append(exc.getMessage());
                        if (exc instanceof DDLException && exc.getCause() instanceof SQLException) {
                            for (SQLException sqlEx = ((SQLException)exc.getCause()).getNextException(); sqlEx != null; sqlEx = sqlEx.getNextException()) {
                                buffer.append("\n\n").append(sqlEx.getMessage());
                            }
                        }
                        message = buffer.toString();
                    }
                    ConnectionPanel.this.errorMessage = message;
                }
            };
            this.databaseConnection.addPropertyChangeListener(connectionListener);
            this.databaseConnection.addExceptionListener(excListener);
            this.databaseConnection.connectAsync();
            int maxLoops = 60;
            int loop = 0;
            while (!("connected".equals(this.state) && "failed".equals(this.state) || loop >= maxLoops)) {
                try {
                    Thread.sleep(1000L);
                    ++loop;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if ("connected".equals(this.state)) {
                    this.databaseConnection.removePropertyChangeListener(connectionListener);
                    this.databaseConnection.removeExceptionListener(excListener);
                    ArrayList<String> schemas = null;
                    try {
                        ResultSet rs;
                        DatabaseMetaData dbMetaData = this.databaseConnection.getConnection().getMetaData();
                        if (dbMetaData.supportsSchemasInTableDefinitions() && (rs = dbMetaData.getSchemas()) != null) {
                            while (rs.next()) {
                                if (schemas == null) {
                                    schemas = new ArrayList<String>();
                                }
                                schemas.add(rs.getString(1).trim());
                            }
                        }
                    }
                    catch (SQLException exc) {
                        Logger.getLogger(ConnectionPanel.class.getName()).log(Level.INFO, exc.getLocalizedMessage(), exc);
                    }
                    this.pw.setSchemas(schemas);
                    return;
                }
                if ("failed".equals(this.state)) {
                    this.databaseConnection.removePropertyChangeListener(connectionListener);
                    this.databaseConnection.removeExceptionListener(excListener);
                    throw new WizardValidationException((JComponent)this.component, this.state, this.errorMessage);
                }
                if (loop < maxLoops) continue;
                this.databaseConnection.removePropertyChangeListener(connectionListener);
                this.databaseConnection.removeExceptionListener(excListener);
                throw new WizardValidationException((JComponent)this.component, "Timeout expired", NbBundle.getMessage(ConnectionPanel.class, (String)"ConnectionPanel_TimeoutExpired"));
            }
            this.databaseConnection.removePropertyChangeListener(connectionListener);
            this.databaseConnection.removeExceptionListener(excListener);
        }
        finally {
            if (this.component != null) {
                this.component.setWaitingState(false);
            }
        }
    }

    public boolean isFinishPanel() {
        return true;
    }
}

