/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ArrayHelpers;
import org.neo4j.values.virtual.VirtualValueGroup;
import org.neo4j.values.virtual.VirtualValues;

public abstract class ListValue
extends VirtualValue
implements SequenceValue,
Iterable<AnyValue> {
    public abstract int size();

    @Override
    public abstract AnyValue value(int var1);

    @Override
    public String getTypeName() {
        return "List";
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean nonEmpty() {
        return this.size() != 0;
    }

    public boolean storable() {
        return false;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder(this.getTypeName() + "{");
        for (i = 0; i < this.size() - 1; ++i) {
            sb.append(this.value(i));
            sb.append(", ");
        }
        if (this.size() > 0) {
            sb.append(this.value(i));
        }
        sb.append('}');
        return sb.toString();
    }

    public ArrayValue toStorableArray() {
        throw new UnsupportedOperationException("List cannot be turned into a storable array");
    }

    @Override
    public boolean isSequenceValue() {
        return true;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapSequence(this);
    }

    @Override
    public boolean equals(VirtualValue other) {
        return other != null && other.isSequenceValue() && this.equals((SequenceValue)((Object)other));
    }

    public AnyValue head() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("head of empty list");
        }
        return this.value(0);
    }

    public AnyValue last() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("last of empty list");
        }
        return this.value(size - 1);
    }

    @Override
    public Iterator<AnyValue> iterator() {
        return new Iterator<AnyValue>(){
            private int count;

            @Override
            public boolean hasNext() {
                return this.count < ListValue.this.size();
            }

            @Override
            public AnyValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ListValue.this.value(this.count++);
            }
        };
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.LIST;
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (!(other instanceof ListValue)) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        ListValue otherList = (ListValue)other;
        if (this.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS && otherList.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS) {
            return this.randomAccessCompareTo(comparator, otherList);
        }
        return this.iteratorCompareTo(comparator, otherList);
    }

    public AnyValue[] asArray() {
        switch (this.iterationPreference()) {
            case RANDOM_ACCESS: {
                return this.randomAccessAsArray();
            }
            case ITERATION: {
                return this.iterationAsArray();
            }
        }
        throw new IllegalStateException("not a valid iteration preference");
    }

    @Override
    public int computeHash() {
        switch (this.iterationPreference()) {
            case RANDOM_ACCESS: {
                return this.randomAccessComputeHash();
            }
            case ITERATION: {
                return this.iterationComputeHash();
            }
        }
        throw new IllegalStateException("not a valid iteration preference");
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        switch (this.iterationPreference()) {
            case RANDOM_ACCESS: {
                this.randomAccessWriteTo(writer);
                break;
            }
            case ITERATION: {
                this.iterationWriteTo(writer);
                break;
            }
            default: {
                throw new IllegalStateException("not a valid iteration preference");
            }
        }
    }

    public ListValue dropNoValues() {
        return new DropNoValuesListValue(this);
    }

    public ListValue slice(int from, int to) {
        int t;
        int f = Math.max(from, 0);
        if (f > (t = Math.min(to, this.size()))) {
            return VirtualValues.EMPTY_LIST;
        }
        return new ListSlice(this, f, t);
    }

    public ListValue tail() {
        return this.slice(1, this.size());
    }

    public ListValue drop(int n) {
        int size = this.size();
        int start = Math.max(0, Math.min(n, size));
        return new ListSlice(this, start, size);
    }

    public ListValue take(int n) {
        int end = Math.max(0, Math.min(n, this.size()));
        return new ListSlice(this, 0, end);
    }

    public ListValue reverse() {
        return new ReversedList(this);
    }

    public ListValue append(AnyValue ... values) {
        if (values.length == 0) {
            return this;
        }
        return new AppendList(this, values);
    }

    public ListValue prepend(AnyValue ... values) {
        if (values.length == 0) {
            return this;
        }
        return new PrependList(this, values);
    }

    private AnyValue[] iterationAsArray() {
        ArrayList<AnyValue> values = new ArrayList<AnyValue>();
        int size = 0;
        for (AnyValue value : this) {
            values.add(value);
            ++size;
        }
        return values.toArray(new AnyValue[size]);
    }

    private AnyValue[] randomAccessAsArray() {
        int size = this.size();
        AnyValue[] values = new AnyValue[size];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.value(i);
        }
        return values;
    }

    private int randomAccessComputeHash() {
        int hashCode = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hashCode = 31 * hashCode + this.value(i).hashCode();
        }
        return hashCode;
    }

    private int iterationComputeHash() {
        int hashCode = 1;
        for (AnyValue value : this) {
            hashCode = 31 * hashCode + value.hashCode();
        }
        return hashCode;
    }

    private <E extends Exception> void randomAccessWriteTo(AnyValueWriter<E> writer) throws E {
        writer.beginList(this.size());
        for (int i = 0; i < this.size(); ++i) {
            this.value(i).writeTo(writer);
        }
        writer.endList();
    }

    private <E extends Exception> void iterationWriteTo(AnyValueWriter<E> writer) throws E {
        writer.beginList(this.size());
        for (AnyValue value : this) {
            value.writeTo(writer);
        }
        writer.endList();
    }

    private int randomAccessCompareTo(Comparator<AnyValue> comparator, ListValue otherList) {
        int x = Integer.compare(this.length(), otherList.length());
        if (x == 0) {
            for (int i = 0; i < this.length(); ++i) {
                x = comparator.compare(this.value(i), otherList.value(i));
                if (x == 0) continue;
                return x;
            }
        }
        return x;
    }

    private int iteratorCompareTo(Comparator<AnyValue> comparator, ListValue otherList) {
        Iterator<AnyValue> thisIterator = this.iterator();
        Iterator<AnyValue> thatIterator = otherList.iterator();
        while (thisIterator.hasNext()) {
            if (!thatIterator.hasNext()) {
                return 1;
            }
            int compare = comparator.compare(thisIterator.next(), thatIterator.next());
            if (compare == 0) continue;
            return compare;
        }
        if (thatIterator.hasNext()) {
            return -1;
        }
        return 0;
    }

    static final class PrependList
    extends ListValue {
        private final ListValue base;
        private final AnyValue[] prepended;

        PrependList(ListValue base, AnyValue[] prepended) {
            this.base = base;
            this.prepended = prepended;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.base.iterationPreference();
        }

        @Override
        public int size() {
            return this.prepended.length + this.base.size();
        }

        @Override
        public AnyValue value(int offset) {
            int size = this.base.size();
            if (offset < this.prepended.length) {
                return this.prepended[offset];
            }
            if (offset < size + this.prepended.length) {
                return this.base.value(offset - this.prepended.length);
            }
            throw new IndexOutOfBoundsException(offset + " is outside range " + size);
        }

        @Override
        public Iterator<AnyValue> iterator() {
            switch (this.base.iterationPreference()) {
                case RANDOM_ACCESS: {
                    return super.iterator();
                }
                case ITERATION: {
                    return Iterators.prependTo(this.base.iterator(), (Object[])this.prepended);
                }
            }
            throw new IllegalStateException("unknown iteration preference");
        }
    }

    static final class AppendList
    extends ListValue {
        private final ListValue base;
        private final AnyValue[] appended;

        AppendList(ListValue base, AnyValue[] appended) {
            this.base = base;
            this.appended = appended;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.base.iterationPreference();
        }

        @Override
        public int size() {
            return this.base.size() + this.appended.length;
        }

        @Override
        public AnyValue value(int offset) {
            int size = this.base.size();
            if (offset < size) {
                return this.base.value(offset);
            }
            if (offset < size + this.appended.length) {
                return this.appended[offset - size];
            }
            throw new IndexOutOfBoundsException(offset + " is outside range " + size);
        }

        @Override
        public Iterator<AnyValue> iterator() {
            switch (this.base.iterationPreference()) {
                case RANDOM_ACCESS: {
                    return super.iterator();
                }
                case ITERATION: {
                    return Iterators.appendTo(this.base.iterator(), (Object[])this.appended);
                }
            }
            throw new IllegalStateException("unknown iteration preference");
        }
    }

    static final class ConcatList
    extends ListValue {
        private final ListValue[] lists;
        private int size = -1;

        ConcatList(ListValue[] lists) {
            this.lists = lists;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.ITERATION;
        }

        @Override
        public int size() {
            if (this.size < 0) {
                int s = 0;
                for (ListValue list : this.lists) {
                    s += list.size();
                }
                this.size = s;
            }
            return this.size;
        }

        @Override
        public AnyValue value(int offset) {
            for (ListValue list : this.lists) {
                int size = list.size();
                if (offset < size) {
                    return list.value(offset);
                }
                offset -= size;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    static final class IntegralRangeListValue
    extends ListValue {
        private final long start;
        private final long end;
        private final long step;
        private int length = -1;

        IntegralRangeListValue(long start, long end, long step) {
            this.start = start;
            this.end = end;
            this.step = step;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public String toString() {
            return "Range(" + this.start + "..." + this.end + ", step = " + this.step + ")";
        }

        @Override
        public int size() {
            if (this.length != -1) {
                return this.length;
            }
            long l = (this.end - this.start) / this.step + 1L;
            if (l > Integer.MAX_VALUE) {
                throw new OutOfMemoryError("Cannot index an collection of size " + l);
            }
            this.length = (int)l;
            return Math.max(this.length, 0);
        }

        @Override
        public AnyValue value(int offset) {
            if (offset >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return Values.longValue(this.start + (long)offset * this.step);
        }

        @Override
        public int computeHash() {
            int hashCode = 1;
            long current = this.start;
            int size = this.size();
            int i = 0;
            while (i < size) {
                hashCode = 31 * hashCode + Long.hashCode(current);
                ++i;
                current += this.step;
            }
            return hashCode;
        }
    }

    static final class DropNoValuesListValue
    extends ListValue {
        private final ListValue inner;
        private int size = -1;

        DropNoValuesListValue(ListValue inner) {
            this.inner = inner;
        }

        @Override
        public int size() {
            if (this.size < 0) {
                int s = 0;
                for (int i = 0; i < this.inner.size(); ++i) {
                    if (this.inner.value(i) == Values.NO_VALUE) continue;
                    ++s;
                }
                this.size = s;
            }
            return this.size;
        }

        @Override
        public AnyValue value(int offset) {
            int actualOffset = 0;
            int size = this.inner.size();
            for (int i = 0; i < size; ++i) {
                AnyValue value = this.inner.value(i);
                if (value == Values.NO_VALUE) continue;
                if (actualOffset == offset) {
                    return value;
                }
                ++actualOffset;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return new FilteredIterator();
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.ITERATION;
        }

        private class FilteredIterator
        implements Iterator<AnyValue> {
            private AnyValue next;
            private int index;

            FilteredIterator() {
                this.computeNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public AnyValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                AnyValue current = this.next;
                this.computeNext();
                return current;
            }

            private void computeNext() {
                if (this.index < DropNoValuesListValue.this.inner.size()) {
                    AnyValue candidate;
                    do {
                        if (this.index < DropNoValuesListValue.this.inner.size()) continue;
                        this.next = null;
                        return;
                    } while ((candidate = DropNoValuesListValue.this.inner.value(this.index++)) == Values.NO_VALUE);
                    this.next = candidate;
                    return;
                }
                this.next = null;
            }
        }
    }

    static final class ReversedList
    extends ListValue {
        private final ListValue inner;

        ReversedList(ListValue inner) {
            this.inner = inner;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.inner.iterationPreference();
        }

        @Override
        public int size() {
            return this.inner.size();
        }

        @Override
        public AnyValue value(int offset) {
            return this.inner.value(this.size() - 1 - offset);
        }
    }

    static final class ListSlice
    extends ListValue {
        private final ListValue inner;
        private final int from;
        private final int to;

        ListSlice(ListValue inner, int from, int to) {
            assert (from >= 0);
            assert (to <= inner.size());
            assert (from <= to);
            this.inner = inner;
            this.from = from;
            this.to = to;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.inner.iterationPreference();
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public AnyValue value(int offset) {
            return this.inner.value(offset + this.from);
        }

        @Override
        public Iterator<AnyValue> iterator() {
            switch (this.inner.iterationPreference()) {
                case RANDOM_ACCESS: {
                    return super.iterator();
                }
                case ITERATION: {
                    return new PrefetchingIterator<AnyValue>(){
                        private int count;
                        private Iterator<AnyValue> innerIterator;
                        {
                            this.innerIterator = inner.iterator();
                        }

                        protected AnyValue fetchNextOrNull() {
                            while (this.count < from && this.innerIterator.hasNext()) {
                                this.innerIterator.next();
                                ++this.count;
                            }
                            if (this.count < from || this.count >= to || !this.innerIterator.hasNext()) {
                                return null;
                            }
                            ++this.count;
                            return this.innerIterator.next();
                        }
                    };
                }
            }
            throw new IllegalStateException("unknown iteration preference");
        }
    }

    static final class JavaListListValue
    extends ListValue {
        private final List<AnyValue> values;

        JavaListListValue(List<AnyValue> values) {
            assert (values != null);
            assert (!ArrayHelpers.containsNull(values));
            this.values = values;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.ITERATION;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public AnyValue value(int offset) {
            return this.values.get(offset);
        }

        @Override
        public AnyValue[] asArray() {
            return this.values.toArray(new AnyValue[0]);
        }

        @Override
        public int computeHash() {
            return this.values.hashCode();
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return this.values.iterator();
        }
    }

    static final class ArrayListValue
    extends ListValue {
        private final AnyValue[] values;

        ArrayListValue(AnyValue[] values) {
            assert (values != null);
            assert (!ArrayHelpers.containsNull(values));
            this.values = values;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public AnyValue value(int offset) {
            return this.values[offset];
        }

        @Override
        public AnyValue[] asArray() {
            return this.values;
        }

        @Override
        public int computeHash() {
            return Arrays.hashCode(this.values);
        }
    }

    static final class ArrayValueListValue
    extends ListValue {
        private final ArrayValue array;

        ArrayValueListValue(ArrayValue array) {
            this.array = array;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public boolean storable() {
            return true;
        }

        @Override
        public ArrayValue toStorableArray() {
            return this.array;
        }

        @Override
        public int size() {
            return this.array.length();
        }

        @Override
        public AnyValue value(int offset) {
            return this.array.value(offset);
        }

        @Override
        public int computeHash() {
            return this.array.hashCode();
        }
    }
}

