/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.values.storable.Value;

public interface EntityState {
    public static final EntityState EMPTY = new EmptyEntityState();

    public Iterator<StorageProperty> addedProperties();

    public Iterator<StorageProperty> changedProperties();

    public IntIterable removedProperties();

    public Iterator<StorageProperty> addedAndChangedProperties();

    public boolean hasPropertyChanges();

    public boolean isPropertyChangedOrRemoved(int var1);

    public Value propertyValue(int var1);

    public static class EmptyEntityState
    implements EntityState {
        @Override
        public Iterator<StorageProperty> addedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public Iterator<StorageProperty> changedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public IntIterable removedProperties() {
            return IntSets.immutable.empty();
        }

        @Override
        public Iterator<StorageProperty> addedAndChangedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean hasPropertyChanges() {
            return false;
        }

        @Override
        public boolean isPropertyChangedOrRemoved(int propertyKey) {
            return false;
        }

        @Override
        public Value propertyValue(int propertyKey) {
            return null;
        }
    }
}

