/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import java.io.Serializable;
import java.util.function.Consumer;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.RelationshipVisitor;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.collection.Iterator;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001B\r\u001b\u0005-B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019\u0001\u0007\u0001)A\u0005%\"9\u0011\r\u0001b\u0001\n\u0013\t\u0006B\u00022\u0001A\u0003%!\u000bC\u0004d\u0001\u0001\u0007I\u0011\u00023\t\u000f-\u0004\u0001\u0019!C\u0005Y\"1!\u000f\u0001Q!\n\u0015DQa\u001d\u0001\u0005\u0002QDQ!\u001f\u0001\u0005\u0002iDQa\u001f\u0001\u0005\u0002qDa!!\u0001\u0001\t\u0003Q\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\tY\u0001\u0001C\u0001\u0003'Aq!a\b\u0001\t\u0003\t\t\u0003C\u0004\u0002&\u0001!\t!a\n\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!!\u0014\u0001\t\u0013\tyE\u0001\tQCRDg+\u00197vK\n+\u0018\u000e\u001c3fe*\u00111\u0004H\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001e=\u0005A1m\\7nC:$7O\u0003\u0002 A\u0005Y\u0011N\u001c;feB\u0014X\r^3e\u0015\t\t#%A\u0004sk:$\u0018.\\3\u000b\u0005\r\"\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u00152\u0013AB2za\",'O\u0003\u0002(Q\u0005)a.Z85U*\t\u0011&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001YQ\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\t1\fgn\u001a\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dF\u0001\u0004PE*,7\r\u001e\t\u0004kibT\"\u0001\u001c\u000b\u0005]B\u0014\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0005e\u0002\u0014\u0001B;uS2L!a\u000f\u001c\u0003\u0011\r{gn];nKJ\u0004\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u000fYL'\u000f^;bY*\u0011\u0011IJ\u0001\u0007m\u0006dW/Z:\n\u0005\rs$a\u0005*fY\u0006$\u0018n\u001c8tQ&\u0004h+[:ji>\u0014\u0018!B:uCR,\u0007C\u0001$J\u001b\u00059%B\u0001%\u001f\u0003\u0015\u0001\u0018\u000e]3t\u0013\tQuI\u0001\u0006Rk\u0016\u0014\u0018p\u0015;bi\u0016\fa\u0001P5oSRtDCA'P!\tq\u0005!D\u0001\u001b\u0011\u0015!%\u00011\u0001F\u0003\u0015qw\u000eZ3t+\u0005\u0011\u0006CA*_\u001b\u0005!&BA+W\u0003%\u0001(/[7ji&4XM\u0003\u0002X1\u0006!A.[:u\u0015\tI&,A\u0002ba&T!a\u0017/\u0002\u0017\r|G\u000e\\3di&|gn\u001d\u0006\u0003;\"\nq!Z2mSB\u001cX-\u0003\u0002`)\nyQ*\u001e;bE2,Gj\u001c8h\u0019&\u001cH/\u0001\u0004o_\u0012,7\u000fI\u0001\u0005e\u0016d7/A\u0003sK2\u001c\b%\u0001\u0004ok2dW\rZ\u000b\u0002KB\u0011a-[\u0007\u0002O*\t\u0001.A\u0003tG\u0006d\u0017-\u0003\u0002kO\n9!i\\8mK\u0006t\u0017A\u00038vY2,Gm\u0018\u0013fcR\u0011Q\u000e\u001d\t\u0003M:L!a\\4\u0003\tUs\u0017\u000e\u001e\u0005\bc\"\t\t\u00111\u0001f\u0003\rAH%M\u0001\b]VdG.\u001a3!\u0003\u0019\u0011Xm];miR\tQ\u000f\u0005\u0002wo6\t\u0001)\u0003\u0002y\u0001\nA\u0011I\\=WC2,X-A\u0003dY\u0016\f'\u000fF\u0001N\u00031\u0001(/\u001a<j_V\u001chj\u001c3f+\u0005i\bC\u00014\u007f\u0013\tyxM\u0001\u0003M_:<\u0017AC1eI:{g+\u00197vK\u00069\u0011\r\u001a3O_\u0012,GcA'\u0002\b!1\u0011\u0011\u0002\bA\u0002U\f!B\\8eK>\u0013h*\u001e7m\u0003=\tG\r\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004HcA'\u0002\u0010!1\u0011\u0011C\bA\u0002U\f\u0011B]3m\u001fJtU\u000f\u001c7\u0015\u00075\u000b)\u0002C\u0004\u0002\u0018A\u0001\r!!\u0007\u0002\u0007I,G\u000eE\u0002>\u00037I1!!\b?\u0005a1\u0016N\u001d;vC2\u0014V\r\\1uS>t7\u000f[5q-\u0006dW/Z\u0001\u0018C\u0012$\u0017J\\2p[&twMU3mCRLwN\\:iSB$2!TA\u0012\u0011\u0019\t\t\"\u0005a\u0001k\u00069\u0012\r\u001a3PkR<w.\u001b8h%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d\u000b\u0004\u001b\u0006%\u0002BBA\t%\u0001\u0007Q/A\rbI\u0012,f\u000eZ5sK\u000e$X\r\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004HcA'\u00020!1\u0011\u0011C\nA\u0002U\f\u0001$\u00193e\u0013:\u001cw.\\5oOJ+G.\u0019;j_:\u001c\b.\u001b9t)\ri\u0015Q\u0007\u0005\u0007\u0003o!\u0002\u0019A;\u0002\u0015I,Gn](s\u001dVdG.\u0001\rbI\u0012|U\u000f^4pS:<'+\u001a7bi&|gn\u001d5jaN$2!TA\u001f\u0011\u0019\t9$\u0006a\u0001k\u0006Q\u0012\r\u001a3V]\u0012L'/Z2uK\u0012\u0014V\r\\1uS>t7\u000f[5qgR\u0019Q*a\u0011\t\r\u0005]b\u00031\u0001v\u0003\u0019\t7mY3qiR\u0019Q.!\u0013\t\r\u0005-s\u00031\u0001=\u0003\u0005!\u0018!\u00038vY2\u001c\u0005.Z2l+\u0011\t\t&a\u001a\u0015\t\u0005M\u0013q\f\u000b\u0004\u001b\u0006U\u0003\u0002CA,1\u0011\u0005\r!!\u0017\u0002\u0003\u0019\u0004BAZA.\u001b&\u0019\u0011QL4\u0003\u0011q\u0012\u0017P\\1nKzBq!!\u0019\u0019\u0001\u0004\t\u0019'A\u0003wC2,X\r\u0005\u0003\u0002f\u0005\u001dD\u0002\u0001\u0003\b\u0003SB\"\u0019AA6\u0005\u0005\t\u0015\u0003BA7\u0003g\u00022AZA8\u0013\r\t\th\u001a\u0002\b\u001d>$\b.\u001b8h!\r1\u0017QO\u0005\u0004\u0003o:'AB!osJ+g\r")
public final class PathValueBuilder
implements Consumer<RelationshipVisitor> {
    private final QueryState state;
    private final MutableLongList nodes;
    private final MutableLongList rels;
    private boolean nulled;

    @Override
    public Consumer<RelationshipVisitor> andThen(Consumer<? super RelationshipVisitor> x$1) {
        return Consumer.super.andThen(x$1);
    }

    private MutableLongList nodes() {
        return this.nodes;
    }

    private MutableLongList rels() {
        return this.rels;
    }

    private boolean nulled() {
        return this.nulled;
    }

    private void nulled_$eq(boolean x$1) {
        this.nulled = x$1;
    }

    public AnyValue result() {
        if (this.nulled()) {
            return Values.NO_VALUE;
        }
        return VirtualValues.pathReference((long[])this.nodes().toArray(), (long[])this.rels().toArray());
    }

    public PathValueBuilder clear() {
        this.nodes().clear();
        this.rels().clear();
        this.nulled_$eq(false);
        return this;
    }

    public long previousNode() {
        return this.nodes().getLast();
    }

    public PathValueBuilder addNoValue() {
        this.nulled_$eq(true);
        return this;
    }

    public PathValueBuilder addNode(AnyValue nodeOrNull) {
        return this.nullCheck(nodeOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            VirtualNodeValue node = (VirtualNodeValue)nodeOrNull;
            this.nodes().add(node.id());
            return this;
        });
    }

    public PathValueBuilder addRelationship(AnyValue relOrNull) {
        return this.nullCheck(relOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> this.addRelationship((VirtualRelationshipValue)relOrNull));
    }

    public PathValueBuilder addRelationship(VirtualRelationshipValue rel) {
        this.rels().add(rel.id());
        return this;
    }

    public PathValueBuilder addIncomingRelationship(AnyValue relOrNull) {
        return this.nullCheck(relOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)relOrNull;
            this.rels().add(rel.id());
            this.nodes().add(rel.startNodeId((Consumer)this));
            return this;
        });
    }

    public PathValueBuilder addOutgoingRelationship(AnyValue relOrNull) {
        return this.nullCheck(relOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)relOrNull;
            this.rels().add(rel.id());
            this.nodes().add(rel.endNodeId((Consumer)this));
            return this;
        });
    }

    public PathValueBuilder addUndirectedRelationship(AnyValue relOrNull) {
        return this.nullCheck(relOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)relOrNull;
            long previousNode = this.nodes().getLast();
            long start = rel.startNodeId((Consumer)this);
            if (start == previousNode) {
                return this.addOutgoingRelationship((AnyValue)rel);
            }
            return this.addIncomingRelationship((AnyValue)rel);
        });
    }

    public PathValueBuilder addIncomingRelationships(AnyValue relsOrNull) {
        return this.nullCheck(relsOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            ListValue relsToAdd = (ListValue)relsOrNull;
            java.util.Iterator iterator = relsToAdd.iterator();
            while (iterator.hasNext()) {
                this.addIncomingRelationship((AnyValue)((VirtualRelationshipValue)iterator.next()));
            }
            return this;
        });
    }

    public PathValueBuilder addOutgoingRelationships(AnyValue relsOrNull) {
        return this.nullCheck(relsOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            ListValue relsToAdd = (ListValue)relsOrNull;
            java.util.Iterator iterator = relsToAdd.iterator();
            while (iterator.hasNext()) {
                this.addOutgoingRelationship((AnyValue)((VirtualRelationshipValue)iterator.next()));
            }
            return this;
        });
    }

    public PathValueBuilder addUndirectedRelationships(AnyValue relsOrNull) {
        return this.nullCheck(relsOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            block0: {
                ListValue relsToAdd = (ListValue)relsOrNull;
                java.util.Iterator relIterator = relsToAdd.iterator();
                if (!relIterator.hasNext()) break block0;
                VirtualRelationshipValue first = (VirtualRelationshipValue)relIterator.next();
                this.addUndirectedRelationship((AnyValue)first);
                this.consumeIterator$1(CollectionConverters$.MODULE$.IteratorHasAsScala(relIterator).asScala());
            }
            return this;
        });
    }

    @Override
    public void accept(RelationshipVisitor t) {
        RelationshipScanCursor cursor = this.state.cursors().relationshipScanCursor();
        this.state.query().singleRelationship(t.id(), cursor);
        cursor.next();
        t.visit(cursor.sourceNodeReference(), cursor.targetNodeReference(), cursor.type());
    }

    private <A> PathValueBuilder nullCheck(A value, Function0<PathValueBuilder> f) {
        A a = value;
        if (a == null || Values.NO_VALUE == a) {
            this.nulled_$eq(true);
            return this;
        }
        return (PathValueBuilder)f.apply();
    }

    private final void consumeIterator$1(Iterator i) {
        while (i.hasNext()) {
            this.addUndirectedRelationship((AnyValue)((VirtualRelationshipValue)i.next()));
        }
    }

    public PathValueBuilder(QueryState state) {
        this.state = state;
        this.nodes = LongLists.mutable.empty();
        this.rels = LongLists.mutable.empty();
        this.nulled = false;
    }
}

