/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.net.ssl.SSLException;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.connection.BoltConnectionMetricsMonitor;
import org.neo4j.bolt.protocol.common.connection.BoltDriverMetricsMonitor;
import org.neo4j.bolt.protocol.common.connection.ConnectionHintProvider;
import org.neo4j.bolt.protocol.common.connection.DefaultConnectionHintProvider;
import org.neo4j.bolt.protocol.common.connector.Connector;
import org.neo4j.bolt.protocol.common.connector.connection.AtomicSchedulingConnection;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.executor.ExecutorServiceFactory;
import org.neo4j.bolt.protocol.common.connector.executor.NettyThreadFactory;
import org.neo4j.bolt.protocol.common.connector.executor.ThreadPoolExecutorServiceFactory;
import org.neo4j.bolt.protocol.common.connector.listener.AuthenticationTimeoutConnectorListener;
import org.neo4j.bolt.protocol.common.connector.listener.KeepAliveConnectorListener;
import org.neo4j.bolt.protocol.common.connector.listener.MetricsConnectorListener;
import org.neo4j.bolt.protocol.common.connector.listener.ReadLimitConnectorListener;
import org.neo4j.bolt.protocol.common.connector.listener.ResetMessageConnectorListener;
import org.neo4j.bolt.protocol.common.connector.listener.ResponseMetricsConnectorListener;
import org.neo4j.bolt.protocol.common.connector.netty.DomainSocketNettyConnector;
import org.neo4j.bolt.protocol.common.connector.netty.LocalNettyConnector;
import org.neo4j.bolt.protocol.common.connector.netty.SocketNettyConnector;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.security.basic.BasicAuthentication;
import org.neo4j.bolt.transport.BoltMemoryPool;
import org.neo4j.bolt.transport.NettyMemoryPool;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SslSystemSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.configuration.connectors.CommonConnectorConfig;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.function.Suppliers;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.ssl.config.SslPolicyLoader;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.VisibleForTesting;

public class BoltServer
extends LifecycleAdapter {
    @VisibleForTesting
    public static final Suppliers.Lazy<PooledByteBufAllocator> NETTY_BUF_ALLOCATOR = Suppliers.lazySingleton(() -> new PooledByteBufAllocator(PlatformDependent.directBufferPreferred()));
    private final DbmsInfo dbmsInfo;
    private final JobScheduler jobScheduler;
    private final ConnectorPortRegister connectorPortRegister;
    private final NetworkConnectionTracker connectionTracker;
    private final Config config;
    private final SystemNanoClock clock;
    private final Monitors monitors;
    private final LogService logService;
    private final AuthManager externalAuthManager;
    private final AuthManager internalAuthManager;
    private final AuthManager loopbackAuthManager;
    private final MemoryPools memoryPools;
    private final DefaultDatabaseResolver defaultDatabaseResolver;
    private final ConnectionHintProvider connectionHintProvider;
    private final ExecutorServiceFactory executorServiceFactory;
    private final SslPolicyLoader sslPolicyLoader;
    private final BoltProtocolRegistry protocolRegistry;
    private final AuthConfigProvider authConfigProvider;
    private final TransactionManager transactionManager;
    private final RoutingService routingService;
    private final InternalLog log;
    private final LifeSupport connectorLife = new LifeSupport();
    private BoltMemoryPool memoryPool;
    private EventLoopGroup eventLoopGroup;
    private ExecutorService executorService;
    private BoltConnectionMetricsMonitor connectionMetricsMonitor;
    private BoltDriverMetricsMonitor driverMetricsMonitor;

    public BoltServer(DbmsInfo dbmsInfo, JobScheduler jobScheduler, ConnectorPortRegister connectorPortRegister, NetworkConnectionTracker connectionTracker, TransactionManager transactionManager, Config config, SystemNanoClock clock, Monitors monitors, LogService logService, DependencyResolver dependencyResolver, AuthManager externalAuthManager, AuthManager internalAuthManager, AuthManager loopbackAuthManager, MemoryPools memoryPools, RoutingService routingService, DefaultDatabaseResolver defaultDatabaseResolver) {
        this.dbmsInfo = dbmsInfo;
        this.jobScheduler = jobScheduler;
        this.connectorPortRegister = connectorPortRegister;
        this.connectionTracker = connectionTracker;
        this.transactionManager = transactionManager;
        this.config = config;
        this.clock = clock;
        this.monitors = monitors;
        this.logService = logService;
        this.externalAuthManager = externalAuthManager;
        this.internalAuthManager = internalAuthManager;
        this.loopbackAuthManager = loopbackAuthManager;
        this.memoryPools = memoryPools;
        this.defaultDatabaseResolver = defaultDatabaseResolver;
        this.connectionHintProvider = DefaultConnectionHintProvider.CONNECTION_HINT_PROVIDER_FUNCTION.apply(config);
        this.executorServiceFactory = new ThreadPoolExecutorServiceFactory((Integer)config.get(BoltConnector.thread_pool_min_size), (Integer)config.get(BoltConnector.thread_pool_max_size), true, (Duration)config.get(BoltConnector.thread_pool_keep_alive), (Integer)config.get(BoltConnectorInternalSettings.unsupported_thread_pool_queue_size), this.jobScheduler.threadFactory(Group.BOLT_WORKER));
        this.routingService = routingService;
        this.sslPolicyLoader = (SslPolicyLoader)dependencyResolver.resolveDependency(SslPolicyLoader.class);
        this.authConfigProvider = (AuthConfigProvider)dependencyResolver.resolveDependency(AuthConfigProvider.class);
        this.log = logService.getInternalLog(BoltServer.class);
        this.protocolRegistry = BoltProtocolRegistry.builder().register(BoltProtocol.available()).build();
    }

    private boolean isEnabled() {
        return (Boolean)this.config.get(BoltConnector.enabled);
    }

    @VisibleForTesting
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void init() {
        if (!this.isEnabled()) {
            return;
        }
        if (((Boolean)this.config.get(CommonConnectorConfig.ocsp_stapling_enabled)).booleanValue()) {
            this.enableOcspStapling();
            this.log.info("Enabled OCSP stapling support");
        }
        this.jobScheduler.setThreadFactory(Group.BOLT_NETWORK_IO, NettyThreadFactory::new);
        Predicate<ConnectorTransport> filter = (Boolean)this.config.get(BoltConnectorInternalSettings.use_native_transport) != false ? transport -> true : Predicate.not(ConnectorTransport::isNative);
        ConnectorTransport transport2 = ConnectorTransport.selectOptimal(filter).orElseThrow(() -> new IllegalStateException("No transport implementations available within current environment"));
        this.log.info("Using connector transport %s", new Object[]{transport2.getName()});
        this.eventLoopGroup = transport2.createEventLoopGroup(this.jobScheduler.threadFactory(Group.BOLT_NETWORK_IO));
        this.executorService = this.executorServiceFactory.create();
        this.connectionMetricsMonitor = (BoltConnectionMetricsMonitor)this.monitors.newMonitor(BoltConnectionMetricsMonitor.class, new String[0]);
        this.driverMetricsMonitor = (Boolean)this.config.get(BoltConnector.server_bolt_telemetry_enabled) != false ? (BoltDriverMetricsMonitor)this.monitors.newMonitor(BoltDriverMetricsMonitor.class, new String[0]) : BoltDriverMetricsMonitor.noop();
        ByteBufAllocator allocator = this.getBufferAllocator();
        Connection.Factory connectionFactory = this.createConnectionFactory();
        Integer streamingBufferSize = (Integer)this.config.get(BoltConnectorInternalSettings.streaming_buffer_size);
        Integer streamingFlushThreshold = (Integer)this.config.get(BoltConnectorInternalSettings.streaming_flush_threshold);
        if (((Boolean)this.config.get(BoltConnectorInternalSettings.enable_loopback_auth)).booleanValue()) {
            this.registerConnector(this.createDomainSocketConnector(connectionFactory, transport2, BoltServer.createAuthentication(this.loopbackAuthManager), allocator, streamingBufferSize, streamingFlushThreshold));
            this.log.info("Configured loopback (domain socket) Bolt connector");
        }
        InetSocketAddress listenAddress = ((org.neo4j.configuration.helpers.SocketAddress)this.config.get(BoltConnector.listen_address)).socketAddress();
        BoltConnector.EncryptionLevel encryptionLevel = (BoltConnector.EncryptionLevel)this.config.get(BoltConnector.encryption_level);
        boolean encryptionRequired = encryptionLevel == BoltConnector.EncryptionLevel.REQUIRED;
        SslContext sslContext = null;
        if (encryptionLevel != BoltConnector.EncryptionLevel.DISABLED) {
            if (!this.sslPolicyLoader.hasPolicyForSource(SslPolicyScope.BOLT)) {
                throw new IllegalStateException("Requested encryption level " + encryptionLevel + " for Bolt connector but no SSL policy was given");
            }
            try {
                sslContext = this.sslPolicyLoader.getPolicy(SslPolicyScope.BOLT).nettyServerContext();
            }
            catch (SSLException ex) {
                throw new IllegalStateException("Failed to load SSL policy for Bolt connector", ex);
            }
        }
        this.registerConnector(this.createSocketConnector(listenAddress, connectionFactory, encryptionRequired, transport2, sslContext, BoltServer.createAuthentication(this.externalAuthManager), ConnectorType.BOLT, allocator, streamingBufferSize, streamingFlushThreshold));
        this.log.info("Configured external Bolt connector with listener address %s", new Object[]{listenAddress});
        boolean isRoutingEnabled = (Boolean)this.config.get(GraphDatabaseSettings.routing_enabled);
        if (isRoutingEnabled && this.dbmsInfo == DbmsInfo.ENTERPRISE) {
            InetSocketAddress internalListenAddress = this.config.isExplicitlySet(GraphDatabaseSettings.routing_listen_address) ? ((org.neo4j.configuration.helpers.SocketAddress)this.config.get(GraphDatabaseSettings.routing_listen_address)).socketAddress() : new InetSocketAddress(((org.neo4j.configuration.helpers.SocketAddress)this.config.get(BoltConnector.listen_address)).getHostname(), ((org.neo4j.configuration.helpers.SocketAddress)this.config.get(GraphDatabaseSettings.routing_listen_address)).getPort());
            boolean internalEncryptionRequired = false;
            SslContext internalSslContext = null;
            if (this.sslPolicyLoader.hasPolicyForSource(SslPolicyScope.CLUSTER)) {
                internalEncryptionRequired = true;
                try {
                    internalSslContext = this.sslPolicyLoader.getPolicy(SslPolicyScope.CLUSTER).nettyServerContext();
                }
                catch (SSLException ex) {
                    throw new IllegalStateException("Failed to load SSL policy for server side routing within Bolt: Cluster policy", ex);
                }
            }
            this.registerConnector(this.createSocketConnector(internalListenAddress, connectionFactory, internalEncryptionRequired, transport2, internalSslContext, BoltServer.createAuthentication(this.internalAuthManager), ConnectorType.INTRA_BOLT, allocator, streamingBufferSize, streamingFlushThreshold));
            this.log.info("Configured internal Bolt connector with listener address %s", new Object[]{internalListenAddress});
        }
        if (((Boolean)this.config.get(BoltConnectorInternalSettings.enable_local_connector)).booleanValue()) {
            this.registerConnector(this.createLocalConnector(connectionFactory, transport2, BoltServer.createAuthentication(this.externalAuthManager), allocator, streamingBufferSize, streamingFlushThreshold));
        }
        this.log.info("Bolt server loaded");
        this.connectorLife.init();
    }

    public void start() throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        this.connectorLife.start();
        this.log.info("Bolt server started");
    }

    public void stop() throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        this.log.info("Requested Bolt server shutdown");
        this.connectorLife.stop();
    }

    public void shutdown() {
        if (this.isEnabled()) {
            this.log.info("Shutting down Bolt server");
            this.connectorLife.shutdown();
            this.eventLoopGroup.shutdownGracefully((long)((Integer)this.config.get(GraphDatabaseInternalSettings.netty_server_shutdown_quiet_period)).intValue(), ((Duration)this.config.get(GraphDatabaseInternalSettings.netty_server_shutdown_timeout)).toSeconds(), TimeUnit.SECONDS).syncUninterruptibly();
            List<Runnable> remainingJobs = this.executorService.shutdownNow();
            if (!remainingJobs.isEmpty()) {
                this.log.warn("Forcefully killed %d remaining Bolt jobs to fulfill shutdown request", new Object[]{remainingJobs.size()});
            }
            this.log.info("Bolt server has been shut down");
        }
        if (this.memoryPool != null) {
            this.memoryPool.close();
        }
    }

    private ByteBufAllocator getBufferAllocator() {
        PooledByteBufAllocator allocator = (PooledByteBufAllocator)NETTY_BUF_ALLOCATOR.get();
        BoltMemoryPool pool = new BoltMemoryPool(this.memoryPools, (ByteBufAllocatorMetric)allocator.metric());
        this.connectorLife.add((Lifecycle)new BoltMemoryPoolLifeCycleAdapter(pool));
        this.memoryPool = pool;
        return allocator;
    }

    private void registerConnector(Connector connector) {
        Long readLimit;
        Duration authenticationTimeout;
        connector.registerListener(new MetricsConnectorListener(this.connectionMetricsMonitor));
        if (((Boolean)this.config.get(BoltConnectorInternalSettings.enable_response_metrics)).booleanValue()) {
            connector.registerListener(new ResponseMetricsConnectorListener(this.connectionMetricsMonitor));
        }
        if (!(authenticationTimeout = (Duration)this.config.get(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_timeout)).isZero()) {
            connector.registerListener(new AuthenticationTimeoutConnectorListener(authenticationTimeout, this.logService.getInternalLogProvider()));
        }
        BoltConnector.KeepAliveRequestType keepAliveMechanism = (BoltConnector.KeepAliveRequestType)this.config.get(BoltConnector.connection_keep_alive_type);
        long keepAliveInterval = ((Duration)this.config.get(BoltConnector.connection_keep_alive)).toMillis();
        if (keepAliveMechanism != BoltConnector.KeepAliveRequestType.OFF) {
            connector.registerListener(new KeepAliveConnectorListener(keepAliveMechanism != BoltConnector.KeepAliveRequestType.ALL, keepAliveInterval, this.logService.getInternalLogProvider()));
        }
        if ((readLimit = (Long)this.config.get(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_max_inbound_bytes)) != 0L) {
            connector.registerListener(new ReadLimitConnectorListener(readLimit, this.logService.getInternalLogProvider()));
        }
        connector.registerListener(new ResetMessageConnectorListener(this.logService.getInternalLogProvider()));
        this.connectorLife.add((Lifecycle)connector);
    }

    private Connection.Factory createConnectionFactory() {
        return new AtomicSchedulingConnection.Factory(this.executorService, (Clock)this.clock, this.logService);
    }

    private static Authentication createAuthentication(AuthManager authManager) {
        return new BasicAuthentication(authManager);
    }

    private void enableOcspStapling() {
        if (!SslProvider.JDK.equals(this.config.get(SslSystemSettings.netty_ssl_provider))) {
            throw new IllegalArgumentException("OCSP Server stapling can only be used with JDK ssl provider (see " + SslSystemSettings.netty_ssl_provider.name() + ")");
        }
        System.setProperty("jdk.tls.server.enableStatusRequestExtension", "true");
    }

    private Connector createSocketConnector(SocketAddress bindAddress, Connection.Factory connectionFactory, boolean encryptionRequired, ConnectorTransport transport, SslContext sslContext, Authentication authentication, ConnectorType connectorType, ByteBufAllocator allocator, int streamingBufferSize, int streamingFlushThreshold) {
        return new SocketNettyConnector("bolt", bindAddress, this.config, connectorType, this.connectorPortRegister, (MemoryPool)this.memoryPool, (Clock)this.clock, allocator, this.eventLoopGroup, transport, connectionFactory, this.connectionTracker, sslContext, encryptionRequired, (Boolean)this.config.get(BoltConnectorInternalSettings.tcp_keep_alive), this.protocolRegistry, authentication, this.authConfigProvider, this.defaultDatabaseResolver, this.connectionHintProvider, this.transactionManager, streamingBufferSize, streamingFlushThreshold, this.routingService, this.driverMetricsMonitor, this.logService.getUserLogProvider(), this.logService.getInternalLogProvider());
    }

    private Connector createDomainSocketConnector(Connection.Factory connectionFactory, ConnectorTransport transport, Authentication authentication, ByteBufAllocator allocator, int streamingBufferSize, int streamingFlushThreshold) {
        if (this.config.get(BoltConnectorInternalSettings.unsupported_loopback_listen_file) == null) {
            throw new IllegalArgumentException("A file has not been specified for use with the loopback domain socket.");
        }
        return new DomainSocketNettyConnector("bolt-loopback", (Path)this.config.get(BoltConnectorInternalSettings.unsupported_loopback_listen_file), this.config, (MemoryPool)this.memoryPool, (Clock)this.clock, allocator, this.eventLoopGroup, transport, connectionFactory, this.connectionTracker, this.protocolRegistry, authentication, this.authConfigProvider, this.defaultDatabaseResolver, this.connectionHintProvider, this.transactionManager, streamingBufferSize, streamingFlushThreshold, this.routingService, this.driverMetricsMonitor, this.logService.getUserLogProvider(), this.logService.getInternalLogProvider());
    }

    private Connector createLocalConnector(Connection.Factory connectionFactory, ConnectorTransport transport, Authentication authentication, ByteBufAllocator allocator, int streamingBufferSize, int streamingFlushThreshold) {
        return new LocalNettyConnector("bolt-local", (SocketAddress)new LocalAddress((String)this.config.get(BoltConnectorInternalSettings.local_channel_address)), (MemoryPool)this.memoryPool, (Clock)this.clock, connectionFactory, this.connectionTracker, this.protocolRegistry, authentication, this.authConfigProvider, this.defaultDatabaseResolver, this.connectionHintProvider, this.transactionManager, streamingBufferSize, streamingFlushThreshold, this.routingService, this.logService.getUserLogProvider(), this.logService.getInternalLogProvider(), transport, this.eventLoopGroup, this.config, allocator, this.driverMetricsMonitor);
    }

    private static class BoltMemoryPoolLifeCycleAdapter
    extends LifecycleAdapter {
        private final NettyMemoryPool pool;

        private BoltMemoryPoolLifeCycleAdapter(NettyMemoryPool pool) {
            this.pool = pool;
        }

        public void shutdown() {
            this.pool.close();
        }
    }
}

