/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.util.Preconditions;

public class StreamingState
implements BoltStateMachineState {
    private BoltStateMachineState readyState;
    private BoltStateMachineState interruptedState;
    private BoltStateMachineState failedState;

    @Override
    public BoltStateMachineState process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (message instanceof PullAllMessage) {
            return this.processPullAllMessage(context);
        }
        if (message instanceof DiscardAllMessage) {
            return this.processDiscardAllMessage(context);
        }
        if (message instanceof ResetMessage) {
            return this.processResetMessage(context);
        }
        if (message instanceof InterruptSignal) {
            return this.interruptedState;
        }
        return null;
    }

    @Override
    public String name() {
        return "STREAMING";
    }

    public void setReadyState(BoltStateMachineState readyState) {
        this.readyState = readyState;
    }

    public void setInterruptedState(BoltStateMachineState interruptedState) {
        this.interruptedState = interruptedState;
    }

    public void setFailedState(BoltStateMachineState failedState) {
        this.failedState = failedState;
    }

    private BoltStateMachineState processPullAllMessage(StateMachineContext context) throws BoltConnectionFatality {
        return this.processStreamResultMessage(true, context);
    }

    private BoltStateMachineState processDiscardAllMessage(StateMachineContext context) throws BoltConnectionFatality {
        return this.processStreamResultMessage(false, context);
    }

    private BoltStateMachineState processResetMessage(StateMachineContext context) throws BoltConnectionFatality {
        boolean success = context.resetMachine();
        return success ? this.readyState : this.failedState;
    }

    private BoltStateMachineState processStreamResultMessage(boolean pull, StateMachineContext context) throws BoltConnectionFatality {
        try {
            context.connectionState().getStatementProcessor().streamResult((ThrowingConsumer<BoltResult, Exception>)((ThrowingConsumer)recordStream -> context.connectionState().getResponseHandler().onRecords((BoltResult)recordStream, pull)));
            return this.readyState;
        }
        catch (AuthorizationExpiredException e) {
            context.handleFailure(e, true);
            return this.failedState;
        }
        catch (Throwable e) {
            context.handleFailure(e, false);
            return this.failedState;
        }
    }

    private void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        Preconditions.checkState((this.interruptedState != null ? 1 : 0) != 0, (String)"Interrupted state not set");
        Preconditions.checkState((this.failedState != null ? 1 : 0) != 0, (String)"Failed state not set");
    }
}

