/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.messaging;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum StructType {
    NODE(78, "Node"),
    RELATIONSHIP(82, "Relationship"),
    UNBOUND_RELATIONSHIP(114, "Relationship"),
    PATH(80, "Path"),
    POINT_2D(88, "Point"),
    POINT_3D(89, "Point"),
    DATE(68, "LocalDate"),
    TIME(84, "OffsetTime"),
    LOCAL_TIME(116, "LocalTime"),
    LOCAL_DATE_TIME(100, "LocalDateTime"),
    DATE_TIME_WITH_ZONE_OFFSET(70, "OffsetDateTime"),
    DATE_TIME_WITH_ZONE_NAME(102, "ZonedDateTime"),
    DURATION(69, "Duration");

    private final byte signature;
    private final String description;
    private static Map<Byte, StructType> knownTypesBySignature;

    private StructType(byte signature, String description) {
        this.signature = signature;
        this.description = description;
    }

    public byte signature() {
        return this.signature;
    }

    public String description() {
        return this.description;
    }

    public static StructType valueOf(byte signature) {
        return knownTypesBySignature.get(signature);
    }

    public static StructType valueOf(char signature) {
        return knownTypesBySignature.get((byte)signature);
    }

    private static Map<Byte, StructType> knownTypesBySignature() {
        StructType[] types = StructType.values();
        HashMap<Byte, StructType> result = new HashMap<Byte, StructType>(types.length * 2);
        for (StructType type : types) {
            result.put(type.signature, type);
        }
        return Collections.unmodifiableMap(result);
    }

    static {
        knownTypesBySignature = StructType.knownTypesBySignature();
    }
}

