/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf;

import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;
import org.mybatis.scripting.thymeleaf.SqlGenerator;
import org.mybatis.scripting.thymeleaf.ThymeleafLanguageDriverConfig;
import org.mybatis.scripting.thymeleaf.ThymeleafSqlSource;
import org.mybatis.scripting.thymeleaf.support.TemplateFilePathProvider;
import org.thymeleaf.ITemplateEngine;

public class ThymeleafLanguageDriver
implements LanguageDriver {
    private final SqlGenerator sqlGenerator;

    public ThymeleafLanguageDriver() {
        this.sqlGenerator = this.configure(new SqlGenerator(ThymeleafLanguageDriverConfig.newInstance()));
    }

    public ThymeleafLanguageDriver(ThymeleafLanguageDriverConfig config) {
        this.sqlGenerator = this.configure(new SqlGenerator(config));
        TemplateFilePathProvider.setLanguageDriverConfig(config);
    }

    public ThymeleafLanguageDriver(ITemplateEngine templateEngine) {
        this.sqlGenerator = this.configure(new SqlGenerator(templateEngine));
    }

    private SqlGenerator configure(SqlGenerator sqlGenerator) {
        sqlGenerator.setContextFactory(new ThymeleafSqlSource.ContextFactory());
        return sqlGenerator;
    }

    public ParameterHandler createParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        return new DefaultParameterHandler(mappedStatement, parameterObject, boundSql);
    }

    public SqlSource createSqlSource(Configuration configuration, XNode script, Class<?> parameterType) {
        return this.createSqlSource(configuration, script.getNode().getTextContent(), parameterType);
    }

    public SqlSource createSqlSource(Configuration configuration, String script, Class<?> parameterType) {
        return new ThymeleafSqlSource(configuration, this.sqlGenerator, script.trim(), parameterType);
    }
}

