/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientEncryptionSettings;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.internal.crypt.capi.MongoCrypt;
import com.mongodb.internal.crypt.capi.MongoCryptOptions;
import com.mongodb.internal.crypt.capi.MongoCrypts;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.internal.crypt.CollectionInfoRetriever;
import com.mongodb.reactivestreams.client.internal.crypt.CommandMarker;
import com.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.mongodb.reactivestreams.client.internal.crypt.KeyManagementService;
import com.mongodb.reactivestreams.client.internal.crypt.KeyRetriever;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.SSLContext;

public final class Crypts {
    private Crypts() {
    }

    public static Crypt createCrypt(MongoClientSettings mongoClientSettings, AutoEncryptionSettings autoEncryptionSettings) {
        MongoClient sharedInternalClient = null;
        MongoClientSettings keyVaultMongoClientSettings = autoEncryptionSettings.getKeyVaultMongoClientSettings();
        if (keyVaultMongoClientSettings == null || !autoEncryptionSettings.isBypassAutoEncryption()) {
            MongoClientSettings defaultInternalMongoClientSettings = MongoClientSettings.builder((MongoClientSettings)mongoClientSettings).applyToConnectionPoolSettings(builder -> builder.minSize(0)).autoEncryptionSettings(null).build();
            sharedInternalClient = MongoClients.create(defaultInternalMongoClientSettings);
        }
        MongoClient keyVaultClient = keyVaultMongoClientSettings == null ? sharedInternalClient : MongoClients.create(keyVaultMongoClientSettings);
        MongoCrypt mongoCrypt = MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions((AutoEncryptionSettings)autoEncryptionSettings));
        return new Crypt(mongoCrypt, Crypts.createKeyRetriever(keyVaultClient, autoEncryptionSettings.getKeyVaultNamespace()), Crypts.createKeyManagementService(autoEncryptionSettings.getKmsProviderSslContextMap()), autoEncryptionSettings.getKmsProviders(), autoEncryptionSettings.getKmsProviderPropertySuppliers(), autoEncryptionSettings.isBypassAutoEncryption(), autoEncryptionSettings.isBypassAutoEncryption() ? null : new CollectionInfoRetriever(sharedInternalClient), new CommandMarker(mongoCrypt, autoEncryptionSettings), sharedInternalClient, keyVaultClient);
    }

    public static Crypt create(MongoClient keyVaultClient, ClientEncryptionSettings settings) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions((ClientEncryptionSettings)settings)), Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers());
    }

    private static KeyRetriever createKeyRetriever(MongoClient keyVaultClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService(Map<String, SSLContext> kmsProviderSslContextMap) {
        return new KeyManagementService(kmsProviderSslContextMap, 10000);
    }

    private static SSLContext getSslContext() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", (Throwable)e);
        }
        return sslContext;
    }
}

